/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.processor.element;

import com.bawnorton.configurable.Configurable;
import com.bawnorton.configurable.Validator;
import com.bawnorton.configurable.processor.ConfigurableSettings;
import com.bawnorton.configurable.processor.util.AnnotationHelper;
import com.bawnorton.configurable.processor.util.TypeHelper;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;

public class ConfigurableElement {
    private final Element annotatedElement;
    private final String elementName;
    private final boolean isNumeric;
    private final String rightHandSide;
    private final String comment;
    private final Configurable configurable;
    private final AnnotationMirror configurableMirror;
    private final AnnotationMirror validatorMirror;

    public ConfigurableElement(Element annotatedElement, String elementName, boolean isNumeric, String rightHandSide, String comment, Configurable configurable, AnnotationMirror configurableMirror, AnnotationMirror validatorMirror) {
        this.annotatedElement = annotatedElement;
        this.elementName = elementName;
        this.isNumeric = isNumeric;
        this.rightHandSide = rightHandSide;
        this.comment = comment;
        this.configurable = configurable;
        this.configurableMirror = configurableMirror;
        this.validatorMirror = validatorMirror;
    }

    public static ConfigurableElement fromElement(Element element, ProcessingEnvironment processingEnv) {
        VariableTree variableTree;
        ExpressionTree initializer;
        Tree tree;
        Set<Modifier> modifiers = element.getModifiers();
        if (!modifiers.contains((Object)Modifier.PUBLIC)) {
            processingEnv.getMessager().printError("Configurable fields must be public", element);
            return null;
        }
        if (!modifiers.contains((Object)Modifier.STATIC)) {
            processingEnv.getMessager().printError("Configurable fields must be static", element);
            return null;
        }
        if (modifiers.contains((Object)Modifier.FINAL)) {
            processingEnv.getMessager().printError("Configurable fields cannot be final", element);
            return null;
        }
        String elementName = element.getSimpleName().toString();
        boolean isNumeric = TypeHelper.isNumeric(element, processingEnv);
        AnnotationMirror configurableMirror = AnnotationHelper.getAnnotationMirror(element, Configurable.class);
        AnnotationMirror validatorMirror = AnnotationHelper.getNestedAnnotationMirror(configurableMirror, Validator.class);
        String defaultValue = null;
        Trees trees = Trees.instance(processingEnv);
        TreePath treePath = trees.getPath(element);
        if (treePath != null && (tree = treePath.getLeaf()) instanceof VariableTree && (initializer = (variableTree = (VariableTree)tree).getInitializer()) != null) {
            defaultValue = initializer.toString();
        }
        String comment = processingEnv.getElementUtils().getDocComment(element);
        Configurable configurable = element.getAnnotation(Configurable.class);
        return new ConfigurableElement(element, elementName, isNumeric, defaultValue, comment, configurable, configurableMirror, validatorMirror);
    }

    public Element getAnnotatedElement() {
        return this.annotatedElement;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getConfigurableName(ConfigurableSettings settings) {
        if (this.configurable.value().isEmpty()) {
            return settings.namingPolicy().format(this.elementName);
        }
        return settings.namingPolicy().format(this.configurable.value());
    }

    public String getRightHandSide() {
        return this.rightHandSide;
    }

    public String getGroup() {
        return this.configurable.group();
    }

    public String getComment() {
        return this.comment;
    }

    public String getOnSetReference() {
        return this.configurable.onSet();
    }

    public boolean doesSync() {
        return this.configurable.sync();
    }

    public AnnotationMirror getConfigurableMirror() {
        return this.configurableMirror;
    }

    public AnnotationMirror getValidatorMirror() {
        return this.validatorMirror;
    }

    public String getValidatorReference() {
        return this.configurable.validator().value();
    }

    public boolean doesFallback() {
        return this.configurable.validator().fallback();
    }

    public String getFailureMessageReference() {
        return this.configurable.validator().message();
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public boolean isMinSet() {
        return !AnnotationHelper.isDefaultValue(this.validatorMirror, "min");
    }

    public Double getMin() {
        return this.configurable.validator().min();
    }

    public boolean isMaxSet() {
        return !AnnotationHelper.isDefaultValue(this.validatorMirror, "max");
    }

    public Double getMax() {
        return this.configurable.validator().max();
    }
}

