/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism.grid;

import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepository;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.grid.GridScrollMode;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridExtractionStrategy;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridScrollingStrategy;
import com.refinedmods.refinedstorage.common.api.grid.view.AbstractGridResource;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResourceAttributeKey;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.support.tooltip.MouseClientTooltipComponent;
import com.refinedmods.refinedstorage.mekanism.ChemicalRenderer;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import com.refinedmods.refinedstorage.mekanism.ChemicalResourceType;
import com.refinedmods.refinedstorage.mekanism.ChemicalUtil;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;

public class ChemicalGridResource
extends AbstractGridResource<ChemicalResource> {
    private final int id;
    private final ResourceRendering rendering;
    private final List<Component> tooltip;

    public ChemicalGridResource(ChemicalResource resource, String name, Function<GridResourceAttributeKey, Set<String>> attributes) {
        super((PlatformResourceKey)resource, name, attributes);
        this.id = MekanismAPI.CHEMICAL_REGISTRY.getId((Object)resource.chemical());
        this.rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(ChemicalResource.class);
        this.tooltip = List.of(resource.chemical().getTextComponent());
    }

    public int getRegistryId() {
        return this.id;
    }

    public List<ClientTooltipComponent> getExtractionHints(ItemStack carriedStack, ResourceRepository<GridResource> repository) {
        ItemStack modifiedStack = carriedStack.copy();
        return Optional.ofNullable((IChemicalHandler)modifiedStack.getCapability(ChemicalUtil.ITEM_CAPABILITY)).map(handler -> handler.insertChemical(new ChemicalStack(((ChemicalResource)this.resource).chemical(), Platform.INSTANCE.getBucketAmount()), Action.EXECUTE)).filter(remainder -> remainder.getAmount() != Platform.INSTANCE.getBucketAmount()).map(remainder -> MouseClientTooltipComponent.item((MouseClientTooltipComponent.Type)MouseClientTooltipComponent.Type.LEFT, (ItemStack)modifiedStack, null)).stream().toList();
    }

    @Nullable
    public ResourceAmount getAutocraftingRequest() {
        return new ResourceAmount((ResourceKey)this.resource, Platform.INSTANCE.getBucketAmount());
    }

    public boolean canExtract(ItemStack carriedStack, ResourceRepository<GridResource> repository) {
        if (this.getAmount(repository) == 0L) {
            return false;
        }
        if (carriedStack.isEmpty()) {
            return true;
        }
        ChemicalStack toFill = new ChemicalStack(((ChemicalResource)this.resource).chemical(), repository.getAmount((ResourceKey)this.resource));
        return Optional.ofNullable((IChemicalHandler)carriedStack.getCapability(ChemicalUtil.ITEM_CAPABILITY)).map(handler -> handler.insertChemical(toFill, Action.SIMULATE)).map(remainder -> remainder.getAmount() != toFill.getAmount()).orElse(false);
    }

    public void onExtract(GridExtractMode extractMode, boolean cursor, GridExtractionStrategy extractionStrategy) {
        extractionStrategy.onExtract(this.resource, extractMode, cursor);
    }

    public void onScroll(GridScrollMode scrollMode, GridScrollingStrategy scrollingStrategy) {
    }

    public void render(GuiGraphics graphics, int x, int y) {
        ChemicalRenderer.render(graphics.pose(), x, y, ((ChemicalResource)this.resource).chemical());
    }

    public String getDisplayedAmount(ResourceRepository<GridResource> repository) {
        return this.rendering.formatAmount(this.getAmount(repository), true);
    }

    public String getAmountInTooltip(ResourceRepository<GridResource> repository) {
        return this.rendering.formatAmount(this.getAmount(repository));
    }

    public boolean belongsToResourceType(ResourceType resourceType) {
        return resourceType == ChemicalResourceType.INSTANCE;
    }

    public List<Component> getTooltip() {
        return this.tooltip;
    }

    public Optional<TooltipComponent> getTooltipImage() {
        return Optional.empty();
    }
}

