/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.cloche.integration.jei;

import com.benbenlaw.cloche.block.ClocheBlocks;
import com.benbenlaw.cloche.integration.jei.JEIClochePlugin;
import com.benbenlaw.cloche.recipe.ClocheRecipe;
import com.benbenlaw.core.block.colored.util.IColored;
import com.benbenlaw.core.item.CoreDataComponents;
import com.benbenlaw.core.item.colored.ColoredItem;
import com.benbenlaw.core.recipe.ChanceResult;
import com.benbenlaw.core.util.MouseUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class ClocheRecipeCategory
implements IRecipeCategory<ClocheRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"cloche", (String)"cloche");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cloche", (String)"textures/gui/jei_cloche.png");
    static final RecipeType<ClocheRecipe> RECIPE_TYPE = RecipeType.create((String)"cloche", (String)"cloche", ClocheRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    @Nullable
    public ResourceLocation getRegistryName(ClocheRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ClocheRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((ClocheRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public ClocheRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 140, 37);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ClocheBlocks.CLOCHE.get()));
    }

    public RecipeType<ClocheRecipe> getRecipeType() {
        return JEIClochePlugin.CLOCHE;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.cloche.cloche");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ClocheRecipe recipe, IFocusGroup focusGroup) {
        int size;
        if (Block.byItem((Item)recipe.seed().getItems()[0].getItem()) instanceof IColored || recipe.seed().getItems()[0].getItem() instanceof ColoredItem) {
            String color = (String)recipe.seed().getItems()[0].get((Supplier)CoreDataComponents.COLOR);
            ItemStack coloredStack = new ItemStack((ItemLike)recipe.seed().getItems()[0].getItem());
            coloredStack.set((Supplier)CoreDataComponents.COLOR, (Object)color);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 2, 2).addItemStack(coloredStack)).addRichTooltipCallback((slotView, tooltip) -> {
                if (!recipe.dimension().isEmpty()) {
                    tooltip.add((FormattedText)Component.translatable((String)"jei.dimension.in").append((Component)Component.translatable((String)recipe.dimension()).withStyle(ChatFormatting.GOLD)));
                }
            });
        } else {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 2, 2).addIngredients(recipe.seed())).addRichTooltipCallback((slotView, tooltip) -> {
                if (!recipe.dimension().isEmpty()) {
                    tooltip.add((FormattedText)Component.translatable((String)"jei.dimension.in").append((Component)Component.translatable((String)recipe.dimension()).withStyle(ChatFormatting.GOLD)));
                }
            });
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 2, 20).addIngredients(recipe.soil());
        if (!recipe.catalyst().hasNoItems()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 36, 11).addIngredients(recipe.catalyst())).setBackground((IDrawable)JEIClochePlugin.slotDrawable, -1, -1);
        } else {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 36, 11).addItemStack(Items.AIR.getDefaultInstance())).setBackground((IDrawable)JEIClochePlugin.slotDrawable, -1, -1);
        }
        ArrayList<ChanceResult> modifiedOutputs = new ArrayList<ChanceResult>((Collection<ChanceResult>)recipe.getRollResults());
        if (!recipe.getShearsResult().isEmpty()) {
            modifiedOutputs.addLast(new ChanceResult(recipe.getShearsResult(), 1.0f));
        }
        int centerX = (size = modifiedOutputs.size()) > 0 ? 1 : 10;
        int centerY = size > 4 ? 1 : 10;
        int xOffset = 0;
        int yOffset = 0;
        int index = 0;
        for (int i = 0; i < size; ++i) {
            xOffset = centerX + i % 4 * 18;
            yOffset = centerY + i / 4 * 18;
            int finalIndex = index = i;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 67 + xOffset, yOffset).addItemStack(((ChanceResult)modifiedOutputs.get(i)).stack())).addRichTooltipCallback((slotView, tooltip) -> {
                ChanceResult output = (ChanceResult)modifiedOutputs.get(finalIndex);
                float chance = output.chance();
                tooltip.add((FormattedText)Component.translatable((String)"block.cloche.jei.chance").append(String.valueOf((int)(chance * 100.0f))).append("%").withStyle(ChatFormatting.GOLD));
                if (finalIndex == 0) {
                    tooltip.add((FormattedText)Component.translatable((String)"block.cloche.jei.main_output").withStyle(ChatFormatting.GREEN));
                }
                if (output.stack().is(recipe.getShearsResult().getItem())) {
                    tooltip.add((FormattedText)Component.translatable((String)"block.cloche.jei.shears_result").withStyle(ChatFormatting.GREEN));
                }
                if (recipe.getSeed().test(output.stack()) && finalIndex > 0) {
                    tooltip.add((FormattedText)Component.translatable((String)"block.cloche.jei.seeds_result").withStyle(ChatFormatting.GREEN));
                }
            }).setBackground((IDrawable)JEIClochePlugin.slotDrawable, -1, -1);
        }
    }

    public void draw(ClocheRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (MouseUtil.isMouseAboveArea((int)((int)mouseX), (int)((int)mouseY), (int)0, (int)0, (int)19, (int)10, (int)16, (int)16)) {
            Font font = Minecraft.getInstance().font;
            int duration = recipe.getDuration();
            guiGraphics.renderTooltip(font, (Component)Component.translatable((String)"block.cloche.jei.duration", (Object[])new Object[]{duration}), 2 + (int)mouseX, 6 + (int)mouseY);
        }
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }
}

