/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.cloche.block.entity;

import com.benbenlaw.cloche.block.ClocheBlock;
import com.benbenlaw.cloche.block.entity.ClocheBlockEntities;
import com.benbenlaw.cloche.block.entity.SpeedUpgradeLogic;
import com.benbenlaw.cloche.item.ClocheItems;
import com.benbenlaw.cloche.recipe.ClocheRecipe;
import com.benbenlaw.cloche.recipe.DimensionalUpgradeRecipe;
import com.benbenlaw.cloche.screen.ClocheMenu;
import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.core.block.entity.handler.InputOutputItemHandler;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClocheBlockEntity
extends SyncableBlockEntity
implements MenuProvider {
    public final ContainerData data;
    public static SpeedUpgradeLogic speedUpgradeLogic = new SpeedUpgradeLogic();
    public int progress = 0;
    public int maxProgress = 1000000;
    public String errorMessage = "";
    public static final int SEED_SLOT = 0;
    public static final int SOIL_SLOT = 1;
    public static final int CATALYST_SLOT = 2;
    public static final int UPGRADE_SLOT_1 = 3;
    public static final int UPGRADE_SLOT_2 = 4;
    public static final int UPGRADE_SLOT_3 = 5;
    public static final int[] OUTPUT_SLOTS = new int[]{6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
    private Optional<RecipeHolder<ClocheRecipe>> cachedRecipe = Optional.empty();
    private ItemStack lastSeed = ItemStack.EMPTY;
    private ItemStack lastSoil = ItemStack.EMPTY;
    private ItemStack lastCatalyst = ItemStack.EMPTY;
    private final ItemStackHandler itemHandler = new ItemStackHandler(18){

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            if (slot == 0 || slot == 1 || slot == 2 || slot == 3 || slot == 4 || slot == 5) {
                return 1;
            }
            return slot;
        }

        public int getSlotLimit(int slot) {
            if (slot == 0 || slot == 1 || slot == 2 || slot == 3 || slot == 4 || slot == 5) {
                return 1;
            }
            return slot;
        }

        protected void onContentsChanged(int slot) {
            ClocheBlockEntity.this.setChanged();
            ClocheBlockEntity.this.sync();
            if (slot == 0 || slot == 1 || slot == 2) {
                ClocheBlockEntity.this.cachedRecipe = Optional.empty();
            }
        }
    };
    private final IItemHandler clocheItemHandlerSide = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> false, this::isOutputSlot);

    public ItemStack getSeed() {
        return this.itemHandler.getStackInSlot(0);
    }

    public ItemStack getSoil() {
        return this.itemHandler.getStackInSlot(1);
    }

    public ItemStack getCatalyst() {
        return this.itemHandler.getStackInSlot(2);
    }

    public ItemStack getUpgrade1() {
        return this.itemHandler.getStackInSlot(3);
    }

    public ItemStack getUpgrade2() {
        return this.itemHandler.getStackInSlot(4);
    }

    public ItemStack getUpgrade3() {
        return this.itemHandler.getStackInSlot(5);
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    private boolean isOutputSlot(int slot) {
        for (int outputSlot : OUTPUT_SLOTS) {
            if (slot != outputSlot) continue;
            return true;
        }
        return false;
    }

    public IItemHandler getItemHandlerCapability(Direction side) {
        return this.clocheItemHandlerSide;
    }

    public void setHandler(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    public ClocheBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ClocheBlockEntities.CLOCHE_BLOCK_ENTITY.get(), blockPos, blockState);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> ClocheBlockEntity.this.progress;
                    case 1 -> ClocheBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        ClocheBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        ClocheBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.cloche.cloche");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new ClocheMenu(container, inventory, this.getBlockPos(), this.data);
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        compoundTag.putInt("progress", this.progress);
        compoundTag.putInt("maxProgress", this.maxProgress);
        compoundTag.putString("errorMessage", this.errorMessage);
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        this.progress = compoundTag.getInt("progress");
        this.maxProgress = compoundTag.getInt("maxProgress");
        this.errorMessage = compoundTag.getString("errorMessage");
        super.loadAdditional(compoundTag, provider);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    private boolean inputsChanged() {
        return !ItemStack.matches((ItemStack)this.getSeed(), (ItemStack)this.lastSeed) || !ItemStack.matches((ItemStack)this.getSoil(), (ItemStack)this.lastSoil) || !ItemStack.matches((ItemStack)this.getCatalyst(), (ItemStack)this.lastCatalyst);
    }

    private void updateCachedRecipe() {
        if (this.inputsChanged()) {
            RecipeInput inventory = new RecipeInput(){

                @NotNull
                public ItemStack getItem(int index) {
                    return ClocheBlockEntity.this.itemHandler.getStackInSlot(index);
                }

                public int size() {
                    return ClocheBlockEntity.this.itemHandler.getSlots();
                }
            };
            this.cachedRecipe = this.level.getRecipeManager().getRecipeFor((RecipeType)ClocheRecipe.Type.INSTANCE, inventory, this.level);
            this.lastSeed = this.getSeed().copy();
            this.lastSoil = this.getSoil().copy();
            this.lastCatalyst = this.getCatalyst().copy();
        }
    }

    public void tick() {
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            this.updateCachedRecipe();
            Optional<RecipeHolder<ClocheRecipe>> match = this.cachedRecipe;
            int recipeMaxDuration = 1000000;
            if (match.isPresent()) {
                recipeMaxDuration = ((ClocheRecipe)match.get().value()).getDuration();
            }
            if (((Boolean)this.getBlockState().getValue((Property)ClocheBlock.POWERED)).booleanValue()) {
                if (match.isPresent()) {
                    int newMax = speedUpgradeLogic.getNewDuration(recipeMaxDuration, this.itemHandler, this.level);
                    if (newMax != this.maxProgress) {
                        this.maxProgress = newMax;
                        this.sync();
                    }
                    if (this.maxProgress == Integer.MAX_VALUE) {
                        if (!"block.cloche.error.speed_upgrade".equals(this.errorMessage)) {
                            this.errorMessage = "block.cloche.error.speed_upgrade";
                            this.sync();
                        }
                        this.resetProgress();
                        return;
                    }
                    ClocheRecipe currentRecipe = (ClocheRecipe)match.get().value();
                    if (this.correctDimension(currentRecipe)) {
                        List<ItemStack> results = currentRecipe.rollResults(this.level.random);
                        if (!this.canFitResults(results)) {
                            if (!"block.cloche.error.output_full".equals(this.errorMessage)) {
                                this.errorMessage = "block.cloche.error.output_full";
                                this.sync();
                            }
                            return;
                        }
                        ++this.progress;
                        if (this.progress >= this.maxProgress) {
                            this.resetProgress();
                            this.fillOutputSlots(currentRecipe);
                            this.sync();
                        }
                        if (!"".equals(this.errorMessage)) {
                            this.errorMessage = "";
                            this.sync();
                        }
                    } else {
                        if (!"block.cloche.error.wrong_dimension".equals(this.errorMessage)) {
                            this.errorMessage = "block.cloche.error.wrong_dimension";
                            this.sync();
                        }
                        this.resetProgress();
                    }
                } else {
                    if (!"block.cloche.error.no_recipe".equals(this.errorMessage)) {
                        this.errorMessage = "block.cloche.error.no_recipe";
                        this.sync();
                    }
                    this.resetProgress();
                }
            } else {
                if (!"block.cloche.error.not_on".equals(this.errorMessage)) {
                    this.errorMessage = "block.cloche.error.not_on";
                    this.sync();
                }
                this.resetProgress();
            }
        }
    }

    public boolean correctDimension(ClocheRecipe recipe) {
        assert (this.level != null);
        String clocheDimension = String.valueOf(this.level.dimension().location());
        Optional<String> dimensionalUpgrade = this.getDimensionalUpgradeInfo();
        if (dimensionalUpgrade.isPresent()) {
            clocheDimension = dimensionalUpgrade.get();
        }
        return clocheDimension.equals(recipe.getDimension()) || Objects.equals(recipe.getDimension(), "all");
    }

    public ItemStack hasShearsUpgrade(ClocheRecipe recipe) {
        ItemStack leavesBlock = ItemStack.EMPTY;
        boolean hasUpgrade1 = this.itemHandler.getStackInSlot(3).is(ClocheItems.SHEARS_UPGRADE);
        boolean hasUpgrade2 = this.itemHandler.getStackInSlot(4).is(ClocheItems.SHEARS_UPGRADE);
        boolean hasUpgrade3 = this.itemHandler.getStackInSlot(5).is(ClocheItems.SHEARS_UPGRADE);
        if ((hasUpgrade1 || hasUpgrade2 || hasUpgrade3) && !recipe.shearsResult().isEmpty()) {
            leavesBlock = recipe.shearsResult().copy();
        }
        return leavesBlock;
    }

    public Optional<String> getDimensionalUpgradeInfo() {
        RecipeInput inventory = new RecipeInput(){

            @NotNull
            public ItemStack getItem(int index) {
                return ClocheBlockEntity.this.itemHandler.getStackInSlot(index);
            }

            public int size() {
                return ClocheBlockEntity.this.itemHandler.getSlots();
            }
        };
        Optional match = this.level.getRecipeManager().getRecipeFor((RecipeType)DimensionalUpgradeRecipe.Type.INSTANCE, inventory, this.level);
        return match.map(recipeHolder -> ((DimensionalUpgradeRecipe)recipeHolder.value()).dimension());
    }

    public void resetProgress() {
        this.progress = 0;
    }

    public boolean canFitResults(List<ItemStack> results) {
        for (ItemStack result : results) {
            int remainingToFit = result.getCount();
            for (int outputSlot : OUTPUT_SLOTS) {
                int maxStackSize;
                int spaceLeft;
                ItemStack slotStack = this.itemHandler.getStackInSlot(outputSlot);
                if (slotStack.isEmpty()) {
                    remainingToFit = 0;
                    break;
                }
                if (ItemStack.isSameItem((ItemStack)slotStack, (ItemStack)result) && (spaceLeft = (maxStackSize = slotStack.getMaxStackSize()) - slotStack.getCount()) > 0 && (remainingToFit -= spaceLeft) <= 0) break;
            }
            if (remainingToFit <= 0) continue;
            return false;
        }
        return true;
    }

    public ItemStack hasNoSeedsUpgrade() {
        ItemStack seed = ItemStack.EMPTY;
        boolean hasUpgrade1 = this.itemHandler.getStackInSlot(3).is(ClocheItems.NO_SEEDS_UPGRADE);
        boolean hasUpgrade2 = this.itemHandler.getStackInSlot(4).is(ClocheItems.NO_SEEDS_UPGRADE);
        boolean hasUpgrade3 = this.itemHandler.getStackInSlot(5).is(ClocheItems.NO_SEEDS_UPGRADE);
        if (hasUpgrade1 || hasUpgrade2 || hasUpgrade3) {
            seed = this.itemHandler.getStackInSlot(0);
        }
        return seed;
    }

    public boolean hasNoOtherDropsUpgrade() {
        boolean hasUpgrade1 = this.itemHandler.getStackInSlot(3).is(ClocheItems.NO_OTHER_DROPS_UPGRADE);
        boolean hasUpgrade2 = this.itemHandler.getStackInSlot(4).is(ClocheItems.NO_OTHER_DROPS_UPGRADE);
        boolean hasUpgrade3 = this.itemHandler.getStackInSlot(5).is(ClocheItems.NO_OTHER_DROPS_UPGRADE);
        return hasUpgrade1 || hasUpgrade2 || hasUpgrade3;
    }

    public int getMainOutputUpgradeCount() {
        int mainOutputUpgradeCount = 0;
        if (this.itemHandler.getStackInSlot(3).is(ClocheItems.MAIN_OUTPUT_UPGRADE)) {
            ++mainOutputUpgradeCount;
        }
        if (this.itemHandler.getStackInSlot(4).is(ClocheItems.MAIN_OUTPUT_UPGRADE)) {
            ++mainOutputUpgradeCount;
        }
        if (this.itemHandler.getStackInSlot(5).is(ClocheItems.MAIN_OUTPUT_UPGRADE)) {
            ++mainOutputUpgradeCount;
        }
        return mainOutputUpgradeCount;
    }

    public void fillOutputSlots(ClocheRecipe recipe) {
        ItemStack leavesBlock;
        assert (this.level != null);
        ItemStack seedToRemove = this.hasNoSeedsUpgrade();
        List<ItemStack> results = recipe.rollResults(this.level.random);
        int mainOutputUpgradeCount = this.getMainOutputUpgradeCount();
        if (!results.isEmpty() && mainOutputUpgradeCount > 0) {
            results.getFirst().grow(mainOutputUpgradeCount);
        }
        if (!(leavesBlock = this.hasShearsUpgrade(recipe)).isEmpty()) {
            results.add(this.hasShearsUpgrade(recipe));
        }
        block0: for (ItemStack result : results) {
            if (!seedToRemove.isEmpty() && ItemStack.isSameItem((ItemStack)seedToRemove, (ItemStack)result) && results.size() > 1) continue;
            if (this.hasNoOtherDropsUpgrade()) {
                ItemStack mainOutput = results.getFirst().copy();
                results.clear();
                results.add(mainOutput);
            }
            for (int outputSlot : OUTPUT_SLOTS) {
                int maxStackSize;
                int spaceLeft;
                ItemStack slotStack = this.itemHandler.getStackInSlot(outputSlot);
                if (slotStack.isEmpty()) {
                    this.itemHandler.setStackInSlot(outputSlot, result.copy());
                    result.setCount(0);
                    continue block0;
                }
                if (!ItemStack.isSameItem((ItemStack)slotStack, (ItemStack)result) || (spaceLeft = (maxStackSize = slotStack.getMaxStackSize()) - slotStack.getCount()) <= 0) continue;
                int toAdd = Math.min(spaceLeft, result.getCount());
                slotStack.grow(toAdd);
                result.shrink(toAdd);
                if (result.isEmpty()) continue block0;
            }
        }
    }
}

