/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import com.mojang.serialization.Codec;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum BuffStyle {
    OFF("off"),
    TOPLEFT("topleft"),
    TOPRIGHT("topright"),
    BOTLEFT("botleft"),
    BOTRIGHT("botright");

    private final String name;
    public static final Codec<BuffStyle> CODEC;
    public static final StreamCodec<FriendlyByteBuf, BuffStyle> STREAM_CODEC;

    private BuffStyle(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static BuffStyle getStyle(String name) {
        for (BuffStyle style : BuffStyle.values()) {
            if (!style.getName().equalsIgnoreCase(name)) continue;
            return style;
        }
        return null;
    }

    static {
        CODEC = Codec.STRING.xmap(BuffStyle::getStyle, BuffStyle::getName);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(BuffStyle.class);
    }
}

