/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.ifrecipes.mixin;

import com.benbenlaw.ifrecipes.config.IFConfig;
import com.buuz135.industrial.block.generator.mycelial.MagmaGeneratorType;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorRecipe;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MagmaGeneratorType.class})
public class MagmaGeneratorMixin {
    @Inject(method={"getRecipes"}, at={@At(value="RETURN")}, cancellable=true)
    private void addCustomMagmaRecipesJEI(CallbackInfoReturnable<List<MycelialGeneratorRecipe>> cir) {
        List recipes = (List)cir.getReturnValue();
        for (String line : (List)IFConfig.MAGMA_GENERATOR_FUELS.get()) {
            try {
                String[] parts = line.split(",");
                if (parts.length < 5) continue;
                String itemString = parts[0].trim();
                String fluidString = parts[1].trim();
                String fluidAmount = parts[2].trim();
                String power = parts[3].trim();
                String ticks = parts[4].trim();
                Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemString));
                Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)fluidString));
                MycelialGeneratorRecipe recipe = new MycelialGeneratorRecipe(Arrays.asList(new ArrayList(), List.of(Ingredient.of((ItemLike[])new ItemLike[]{item}))), Arrays.asList(List.of(new FluidStack(fluid, Integer.parseInt(fluidAmount))), new ArrayList()), Integer.parseInt(ticks), Integer.parseInt(power));
                MycelialGeneratorRecipe recipeNoItem = new MycelialGeneratorRecipe(Arrays.asList(new ArrayList(), new ArrayList()), Arrays.asList(List.of(new FluidStack(fluid, Integer.parseInt(fluidAmount))), new ArrayList()), Integer.parseInt(ticks), Integer.parseInt(power) / 2);
                recipes.add(recipe);
                recipes.add(recipeNoItem);
            }
            catch (Exception e) {
                System.out.println("Error parsing magma generator fuel config line: " + line);
            }
        }
        cir.setReturnValue((Object)recipes);
    }

    @Inject(method={"getTankInputPredicates"}, at={@At(value="RETURN")}, cancellable=true)
    private void addCustomMagmaRecipesFluids(CallbackInfoReturnable<List<Predicate<FluidStack>>> cir) {
        List originalPredicates = (List)cir.getReturnValue();
        if (originalPredicates == null || originalPredicates.isEmpty()) {
            System.out.println("No original predicates found \u2014 skipping magma mixin.");
            return;
        }
        ArrayList<Predicate<FluidStack>> predicates = new ArrayList<Predicate<FluidStack>>(originalPredicates);
        ArrayList<Fluid> allowedFluids = new ArrayList<Fluid>();
        for (String line : (List)IFConfig.MAGMA_GENERATOR_FUELS.get()) {
            try {
                String fluidString;
                Fluid fluid;
                String[] parts = line.split(",");
                if (parts.length < 5 || (fluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)(fluidString = parts[1].trim())))) == Fluids.EMPTY || allowedFluids.contains(fluid)) continue;
                System.out.println("Allowing extra fluid: " + fluidString);
                allowedFluids.add(fluid);
            }
            catch (Exception e) {
                System.out.println("Error parsing magma generator fuel config line: " + line);
                e.printStackTrace();
            }
        }
        Predicate originalLavaCheck = (Predicate)predicates.getFirst();
        Predicate<FluidStack> combinedPredicate = fluidStack -> {
            if (originalLavaCheck != null && originalLavaCheck.test(fluidStack)) {
                return true;
            }
            for (Fluid extra : allowedFluids) {
                if (!fluidStack.getFluid().isSame(extra)) continue;
                return true;
            }
            return false;
        };
        predicates.set(0, combinedPredicate);
        cir.setReturnValue(predicates);
    }

    @Inject(method={"getSlotInputPredicates"}, at={@At(value="RETURN")}, cancellable=true)
    private void addCustomMagmaRecipesItems(CallbackInfoReturnable<List<BiPredicate<ItemStack, Integer>>> cir) {
        List originalPredicates = (List)cir.getReturnValue();
        if (originalPredicates == null || originalPredicates.size() < 2) {
            System.out.println("Original predicates invalid or too small \u2014 skipping magma mixin.");
            return;
        }
        ArrayList<BiPredicate<ItemStack, Integer>> predicates = new ArrayList<BiPredicate<ItemStack, Integer>>(originalPredicates);
        ArrayList<Item> allowedItems = new ArrayList<Item>();
        for (String line : (List)IFConfig.MAGMA_GENERATOR_FUELS.get()) {
            try {
                String itemString;
                Item item;
                String[] parts = line.split(",");
                if (parts.length < 5 || (item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)(itemString = parts[0].trim())))).getDefaultInstance().is(ItemStack.EMPTY.getItem()) || allowedItems.contains(item)) continue;
                System.out.println("Allowing extra items: " + itemString);
                allowedItems.add(item);
            }
            catch (Exception e) {
                System.out.println("Error parsing magma generator fuel config line: " + line);
                e.printStackTrace();
            }
        }
        BiPredicate originalRedstoneCheck = (BiPredicate)predicates.get(1);
        BiPredicate<ItemStack, Integer> combinedPredicate = (itemStack, slotIndex) -> {
            if (originalRedstoneCheck != null && originalRedstoneCheck.test(itemStack, slotIndex)) {
                return true;
            }
            for (Item extra : allowedItems) {
                if (!itemStack.is(extra)) continue;
                return true;
            }
            return false;
        };
        predicates.set(1, combinedPredicate);
        cir.setReturnValue(predicates);
    }

    @Inject(method={"canStart"}, at={@At(value="HEAD")}, cancellable=true)
    private void customCanStartCheck(INBTSerializable<CompoundTag>[] inputs, CallbackInfoReturnable<Boolean> cir) {
        SidedFluidTankComponent fluidTank;
        Object object;
        block6: {
            block5: {
                if (inputs.length < 2 || !((object = inputs[0]) instanceof SidedFluidTankComponent)) break block5;
                fluidTank = (SidedFluidTankComponent)object;
                object = inputs[1];
                if (object instanceof SidedInventoryComponent) break block6;
            }
            return;
        }
        SidedInventoryComponent inventory = (SidedInventoryComponent)object;
        for (String line : (List)IFConfig.MAGMA_GENERATOR_FUELS.get()) {
            try {
                String[] parts = line.split(",");
                if (parts.length < 5) continue;
                String fluidString = parts[1].trim();
                int fluidAmount = Integer.parseInt(parts[2].trim());
                int baseFluidAmount = fluidAmount / 2;
                Fluid requiredFluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)fluidString));
                FluidStack tankFluid = fluidTank.getFluidInTank(0);
                if (!tankFluid.getFluid().isSame(requiredFluid) || tankFluid.getAmount() < baseFluidAmount) continue;
                cir.setReturnValue((Object)true);
                return;
            }
            catch (Exception e) {
                System.out.println("Error parsing magma generator fuel config line in canStart: " + line);
            }
        }
    }

    @Inject(method={"getTimeAndPowerGeneration"}, at={@At(value="HEAD")}, cancellable=true)
    private void customTimeAndPowerGeneration(INBTSerializable<CompoundTag>[] inputs, CallbackInfoReturnable<Pair<Integer, Integer>> cir) {
        SidedFluidTankComponent fluidTank;
        INBTSerializable<CompoundTag> iNBTSerializable;
        block8: {
            block7: {
                if (inputs.length < 2 || !((iNBTSerializable = inputs[0]) instanceof SidedFluidTankComponent)) break block7;
                fluidTank = (SidedFluidTankComponent)iNBTSerializable;
                iNBTSerializable = inputs[1];
                if (iNBTSerializable instanceof SidedInventoryComponent) break block8;
            }
            return;
        }
        SidedInventoryComponent inventory = (SidedInventoryComponent)iNBTSerializable;
        FluidStack tankFluid = fluidTank.getFluidInTank(0);
        for (String line : (List)IFConfig.MAGMA_GENERATOR_FUELS.get()) {
            try {
                String[] parts = line.split(",");
                if (parts.length < 5) continue;
                String itemString = parts[0].trim();
                String fluidString = parts[1].trim();
                int fluidAmount = Integer.parseInt(parts[2].trim());
                int configuredPower = Integer.parseInt(parts[3].trim());
                int configuredTicks = Integer.parseInt(parts[4].trim());
                Item requiredItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemString));
                Fluid requiredFluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)fluidString));
                int baseFluidAmount = fluidAmount / 2;
                if (!tankFluid.getFluid().isSame(requiredFluid) || tankFluid.getAmount() < baseFluidAmount) continue;
                if (inventory.getStackInSlot(0).is(requiredItem) && inventory.getStackInSlot(0).getCount() > 0) {
                    if (tankFluid.getAmount() < fluidAmount) continue;
                    fluidTank.drainForced(fluidAmount, IFluidHandler.FluidAction.EXECUTE);
                    inventory.getStackInSlot(0).shrink(1);
                    cir.setReturnValue((Object)Pair.of((Object)configuredTicks, (Object)configuredPower));
                    cir.cancel();
                    return;
                }
                fluidTank.drainForced(baseFluidAmount, IFluidHandler.FluidAction.EXECUTE);
                int halfPower = configuredPower / 2;
                cir.setReturnValue((Object)Pair.of((Object)configuredTicks, (Object)halfPower));
                cir.cancel();
                return;
            }
            catch (Exception e) {
                System.out.println("Error parsing magma generator fuel config line in getTimeAndPowerGeneration: " + line);
            }
        }
    }
}

