/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.starforge.recipe;

import com.benbenlaw.starforge.recipe.StarForgeRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record StarForgeRecipe(int tier, int starPower, int duration, Ingredient input, Optional<List<Ingredient>> extraIngredients, ItemStack result) implements Recipe<StarForgeRecipeInput>
{
    public boolean matches(StarForgeRecipeInput recipeInput, Level level) {
        if (!this.input.test(recipeInput.getItem(0))) {
            return false;
        }
        if (this.extraIngredients().isPresent()) {
            List<Ingredient> extras = this.extraIngredients().get();
            for (int i = 0; i < extras.size(); ++i) {
                if (extras.get(i).test(recipeInput.getItem(i + 1))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack assemble(StarForgeRecipeInput p_345149_, HolderLookup.Provider p_346030_) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int p_43999_, int p_44000_) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider p_336125_) {
        return this.result.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<StarForgeRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<StarForgeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("tier").forGetter(StarForgeRecipe::tier), (App)Codec.INT.fieldOf("star_power").forGetter(StarForgeRecipe::starPower), (App)Codec.INT.fieldOf("duration").forGetter(StarForgeRecipe::duration), (App)Ingredient.CODEC.fieldOf("input").forGetter(StarForgeRecipe::input), (App)Codec.list((Codec)Ingredient.CODEC).optionalFieldOf("extra_ingredients").forGetter(StarForgeRecipe::extraIngredients), (App)ItemStack.CODEC.fieldOf("result").forGetter(StarForgeRecipe::result)).apply((Applicative)instance, StarForgeRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, StarForgeRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        private static StarForgeRecipe read(RegistryFriendlyByteBuf buffer) {
            Optional<List<Ingredient>> extraIngredients;
            int tier = buffer.readInt();
            int starPower = buffer.readInt();
            int duration = buffer.readInt();
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int extraSize = buffer.readVarInt();
            if (extraSize == 0) {
                extraIngredients = Optional.empty();
            } else {
                ArrayList<Ingredient> extras = new ArrayList<Ingredient>();
                for (int i = 0; i < extraSize; ++i) {
                    extras.add((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
                }
                extraIngredients = Optional.of(extras);
            }
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new StarForgeRecipe(tier, starPower, duration, input, extraIngredients, result);
        }

        private static StarForgeRecipe write(RegistryFriendlyByteBuf buffer, StarForgeRecipe recipe) {
            buffer.writeInt(recipe.tier());
            buffer.writeInt(recipe.starPower());
            buffer.writeInt(recipe.duration());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input());
            if (recipe.extraIngredients().isPresent()) {
                List<Ingredient> extras = recipe.extraIngredients().get();
                buffer.writeVarInt(extras.size());
                for (Ingredient ing : extras) {
                    Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.extraIngredients().get().get(extras.indexOf(ing)));
                }
            } else {
                buffer.writeVarInt(0);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result());
            return recipe;
        }

        public MapCodec<StarForgeRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, StarForgeRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }
    }

    public static class Type
    implements RecipeType<StarForgeRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

