/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.starforge.particle.custom;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MovingParticle
extends SimpleAnimatedParticle {
    private Vec3 orbitCenter;
    private double radius;
    private double angle;
    private double orbitSpeed;
    private boolean verticalOrbit;

    protected MovingParticle(ClientLevel level, double x, double y, double z, SpriteSet sprites, Vec3 orbitCenter, double radius, double initialAngle, double orbitSpeed, boolean verticalOrbit) {
        super(level, x, y, z, sprites, 0.0125f);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.quadSize *= 0.25f;
        this.lifetime = 100;
        this.setFadeColor(15916745);
        this.setSpriteFromAge(sprites);
        this.orbitCenter = orbitCenter;
        this.radius = radius;
        this.angle = initialAngle;
        this.orbitSpeed = orbitSpeed;
        this.verticalOrbit = verticalOrbit;
    }

    public void tick() {
        super.tick();
        this.angle += this.orbitSpeed;
        if (this.verticalOrbit) {
            this.x = this.orbitCenter.x;
            this.y = this.orbitCenter.y + Math.cos(this.angle) * this.radius;
            this.z = this.orbitCenter.z + Math.sin(this.angle) * this.radius;
        } else {
            this.x = this.orbitCenter.x + Math.cos(this.angle) * this.radius;
            this.y = this.orbitCenter.y;
            this.z = this.orbitCenter.z + Math.sin(this.angle) * this.radius;
        }
    }

    public void move(double p_106550_, double p_106551_, double p_106552_) {
        this.setBoundingBox(this.getBoundingBox().move(p_106550_, p_106551_, p_106552_));
        this.setLocationFromBoundingbox();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double vx, double vy, double vz) {
            Vec3 center = new Vec3(x, y, z);
            double radius = 0.3;
            double initialAngle = Math.random() * Math.PI * 2.0;
            double orbitSpeed = 0.05;
            boolean verticalOrbit = false;
            return new MovingParticle(level, x, y, z, this.sprites, center, radius, initialAngle, orbitSpeed, verticalOrbit);
        }
    }
}

