/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.starforge.integration.jei;

import com.benbenlaw.starforge.block.SFBlocks;
import com.benbenlaw.starforge.integration.jei.JEISFPlugin;
import com.benbenlaw.starforge.recipe.StarForgeRecipe;
import com.benbenlaw.starforge.util.SFTags;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Iterator;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IScrollGridWidgetFactory;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class StarForgeRecipeCategory
implements IRecipeCategory<StarForgeRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"starforge", (String)"star_forge");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"starforge", (String)"textures/gui/jei_star_forge.png");
    public static final RecipeType<StarForgeRecipe> RECIPE_TYPE = RecipeType.create((String)"starforge", (String)"star_forge", StarForgeRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IScrollGridWidgetFactory<?> scrollGridWidgetFactory;

    public StarForgeRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 140, 100);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)SFBlocks.STAR_FORGE.get()));
        this.scrollGridWidgetFactory = helper.createScrollGridFactory(5, 2);
        this.scrollGridWidgetFactory.setPosition(34, 0);
    }

    public RecipeType<StarForgeRecipe> getRecipeType() {
        return JEISFPlugin.STAR_FORGE;
    }

    public Component getTitle() {
        return Component.literal((String)"Star Forge");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    @Nullable
    public ResourceLocation getRegistryName(StarForgeRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)StarForgeRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((StarForgeRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayoutBuilder, StarForgeRecipe recipe, IFocusGroup iFocusGroup) {
        iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients(recipe.input());
        if (recipe.extraIngredients().isPresent()) {
            for (Ingredient extraInputs : recipe.extraIngredients().get()) {
                ((IRecipeSlotBuilder)iRecipeLayoutBuilder.addSlotToWidget(RecipeIngredientRole.INPUT, this.scrollGridWidgetFactory).addIngredients(extraInputs)).addRichTooltipCallback((slotView, tooltip) -> tooltip.add((FormattedText)Component.literal((String)"On a Pedestal").withStyle(ChatFormatting.GOLD)));
            }
        }
        iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, 117, 76).addItemStack(recipe.result());
    }

    public void draw(StarForgeRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.getInstance();
        PoseStack poseStack = guiGraphics.pose();
        RenderSystem.enableDepthTest();
        poseStack.pushPose();
        poseStack.translate(39.0f, 77.0f, 50.0f);
        float scale = 9.0f;
        poseStack.scale(scale, -scale, scale);
        float centerX = 0.0f;
        float centerY = 0.5f;
        float centerZ = 0.0f;
        poseStack.translate(-centerX, -centerY, -centerZ);
        poseStack.mulPose(Axis.XP.rotationDegrees(17.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(20.0f));
        this.renderStructure(poseStack, mc, recipe);
        poseStack.popPose();
        RenderSystem.disableDepthTest();
    }

    private void renderStructure(PoseStack poseStack, Minecraft mc, StarForgeRecipe recipe) {
        BlockRenderDispatcher dispatcher = mc.getBlockRenderer();
        MultiBufferSource.BufferSource buffer = mc.renderBuffers().bufferSource();
        if (recipe.tier() != -1) {
            Iterator iterator;
            TagKey<Block> baseTag = SFTags.Blocks.STAR_FORGE_BASE_BLOCKS;
            ArrayList baseBlocks = new ArrayList();
            BuiltInRegistries.BLOCK.getTagOrEmpty(baseTag).forEach(baseBlocks::add);
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    if (x == 0 && z == 0 || baseBlocks.isEmpty()) continue;
                    long index = (mc.level.getGameTime() / 20L + (long)x + (long)z) % (long)baseBlocks.size();
                    BlockState blockState = ((Block)((Holder)baseBlocks.get((int)index)).value()).defaultBlockState();
                    this.renderBlock(blockState, poseStack, dispatcher, (MultiBufferSource)buffer, x, -1, z);
                }
            }
            TagKey<Block> pillarTag = SFTags.Blocks.STAR_FORGE_PILLAR_BLOCKS;
            ArrayList pillarBlocks = new ArrayList();
            BuiltInRegistries.BLOCK.getTagOrEmpty(pillarTag).forEach(pillarBlocks::add);
            int[] xs = new int[]{-3, 3};
            int[] zs = new int[]{-3, 3};
            for (int x : xs) {
                for (int z : zs) {
                    for (int y = -1; y < 3; ++y) {
                        if (pillarBlocks.isEmpty()) continue;
                        long index = (mc.level.getGameTime() / 20L + (long)x + (long)z + (long)y) % (long)pillarBlocks.size();
                        BlockState state = ((Block)((Holder)pillarBlocks.get((int)index)).value()).defaultBlockState();
                        this.renderBlock(state, poseStack, dispatcher, (MultiBufferSource)buffer, x, y, z);
                    }
                }
            }
            TagKey<Block> tagKey = this.getTierTag(recipe.tier());
            if (tagKey != null && (iterator = BuiltInRegistries.BLOCK.getTagOrEmpty(tagKey).iterator()).hasNext()) {
                Holder firstBlock = (Holder)iterator.next();
                BlockState state = ((Block)firstBlock.value()).defaultBlockState();
                for (int x : xs) {
                    for (int z : zs) {
                        this.renderBlock(state, poseStack, dispatcher, (MultiBufferSource)buffer, x, 3, z);
                    }
                }
            }
        }
        this.renderBlock(((Block)SFBlocks.STAR_FORGE.get()).defaultBlockState(), poseStack, dispatcher, (MultiBufferSource)buffer, 0, 0, 0);
        buffer.endBatch();
    }

    public TagKey<Block> getTierTag(int tier) {
        return switch (tier) {
            case 1 -> SFTags.Blocks.STAR_FORGE_TIER_1_CAP;
            case 2 -> SFTags.Blocks.STAR_FORGE_TIER_2_CAP;
            case 3 -> SFTags.Blocks.STAR_FORGE_TIER_3_CAP;
            case 4 -> SFTags.Blocks.STAR_FORGE_TIER_4_CAP;
            case 5 -> SFTags.Blocks.STAR_FORGE_TIER_5_CAP;
            default -> null;
        };
    }

    public void getTooltip(ITooltipBuilder tooltip, StarForgeRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        double left = 1.0;
        double top = 50.0;
        double right = 115.0;
        double bottom = 100.0;
        if (mouseX >= left && mouseX <= right && mouseY >= top && mouseY <= bottom) {
            tooltip.add((FormattedText)Component.literal((String)("Tier " + recipe.tier() + " Star Forge")).withStyle(ChatFormatting.GOLD));
            tooltip.add((FormattedText)Component.literal((String)("Star Power: " + recipe.starPower())).withStyle(ChatFormatting.GOLD));
            tooltip.add((FormattedText)Component.literal((String)("Duration: " + recipe.duration())).withStyle(ChatFormatting.GOLD));
        }
    }

    private void renderBlock(BlockState state, PoseStack poseStack, BlockRenderDispatcher dispatcher, MultiBufferSource buffer, int x, int y, int z) {
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, (float)z);
        dispatcher.renderSingleBlock(state, poseStack, buffer, 0xF000F0, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, RenderType.solid());
        poseStack.popPose();
    }
}

