/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.starforge.data;

import com.benbenlaw.starforge.block.SFBlocks;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class SFBlockStatesProvider
extends BlockStateProvider {
    public SFBlockStatesProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "starforge", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.generateStarBlock(SFBlocks.BLUE_STAR);
        this.generateStarBlock(SFBlocks.WHITE_STAR);
        this.generateStarBlock(SFBlocks.ORANGE_STAR);
        this.generateStarBlock(SFBlocks.YELLOW_STAR);
        this.generateStarBlock(SFBlocks.RED_STAR);
        this.generateStarForgeBlock(SFBlocks.STAR_FORGE);
        this.generatePedestalBlock(SFBlocks.PEDESTAL);
        this.blockWithItem(SFBlocks.COSMIC_PLANKS);
        this.generatePillarBlock(SFBlocks.COSMIC_PILLAR);
        this.generateCapBlock(SFBlocks.TIER_1_STAR_FORGE_CAP);
        this.generateCapBlock(SFBlocks.TIER_2_STAR_FORGE_CAP);
        this.generateCapBlock(SFBlocks.TIER_3_STAR_FORGE_CAP);
        this.generateCapBlock(SFBlocks.TIER_4_STAR_FORGE_CAP);
        this.generateCapBlock(SFBlocks.TIER_5_STAR_FORGE_CAP);
    }

    private void generateStarBlock(DeferredBlock<Block> blockRegistryObject) {
        String path = blockRegistryObject.getId().getPath();
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(path, this.modLoc("block/star"))).texture("all", this.modLoc("block/" + path))).texture("particle", this.modLoc("block/" + path))).renderType("cutout");
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), (ModelFile)this.models().getBuilder(path));
    }

    private void generateStarForgeBlock(DeferredBlock<Block> blockRegistryObject) {
        String path = blockRegistryObject.getId().getPath();
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(path, this.modLoc("block/star_forge_model"))).texture("all", this.modLoc("block/" + path))).texture("particle", this.modLoc("block/" + path))).renderType("cutout");
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), (ModelFile)this.models().getBuilder(path));
    }

    private void generatePedestalBlock(DeferredBlock<Block> blockRegistryObject) {
        String path = blockRegistryObject.getId().getPath();
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(path, this.modLoc("block/pedestal_model"))).texture("all", this.modLoc("block/" + path))).texture("particle", this.modLoc("block/" + path))).renderType("cutout");
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), (ModelFile)this.models().getBuilder(path));
    }

    private void generateCapBlock(DeferredBlock<Block> blockRegistryObject) {
        String path = blockRegistryObject.getId().getPath();
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(path, this.modLoc("block/cap"))).texture("all", this.modLoc("block/" + path))).texture("particle", this.modLoc("block/" + path))).renderType("cutout");
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), (ModelFile)this.models().getBuilder(path));
    }

    private void generatePillarBlock(DeferredBlock<Block> blockRegistryObject) {
        String path = blockRegistryObject.getId().getPath();
        this.logBlock((RotatedPillarBlock)blockRegistryObject.get());
        this.itemModels().simpleBlockItem((Block)blockRegistryObject.get());
    }

    private void blockWithItem(DeferredBlock<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }

    private void fluidBlocks(String name, Block block) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().getBuilder(name)).texture("particle", ResourceLocation.fromNamespaceAndPath((String)"starforge", (String)("block/" + name + "_still"))));
    }

    public String getName() {
        return "starforge Block States";
    }
}

