/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.starforge.data;

import com.benbenlaw.starforge.data.SFBlockStatesProvider;
import com.benbenlaw.starforge.data.SFBlockTags;
import com.benbenlaw.starforge.data.SFItemModels;
import com.benbenlaw.starforge.data.SFItemTags;
import com.benbenlaw.starforge.data.SFLang;
import com.benbenlaw.starforge.data.SFLootTables;
import com.benbenlaw.starforge.data.SFRecipes;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="starforge")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new SFRecipes(packOutput, event.getLookupProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(SFLootTables::new, LootContextParamSets.BLOCK)), event.getLookupProvider()));
        SFBlockTags blockTags = new SFBlockTags(packOutput, lookupProvider, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        SFItemTags itemTags = new SFItemTags(packOutput, lookupProvider, blockTags, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)itemTags);
        generator.addProvider(event.includeClient(), (DataProvider)new SFItemModels(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new SFBlockStatesProvider(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new SFLang(packOutput, event.getExistingFileHelper()));
    }
}

