/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.starforge.block.entity.client;

import com.benbenlaw.starforge.block.entity.StarBlockEntity;
import com.benbenlaw.starforge.particle.SFParticles;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class StarBlockEntityRenderer
implements BlockEntityRenderer<StarBlockEntity> {
    private final Random random = new Random();
    private final double[] orbitAngleH = new double[20];
    private final double[] orbitAngleV = new double[20];

    public StarBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(StarBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (entity.getLevel() == null) {
            return;
        }
        float time = (float)entity.getLevel().getGameTime() + tickDelta;
        float rotationY = time * 1.2f % 360.0f;
        float rotationX = (float)Math.sin((double)time * 0.02) * 5.0f;
        float rotationZ = (float)Math.sin((double)time * 0.01) * 10.0f;
        matrices.pushPose();
        matrices.translate(0.5f, 0.5f, 0.5f);
        matrices.mulPose(Axis.YP.rotationDegrees(rotationY));
        matrices.mulPose(Axis.XP.rotationDegrees(rotationX));
        matrices.mulPose(Axis.ZP.rotationDegrees(rotationZ));
        matrices.translate(-0.5f, -0.5f, -0.5f);
        Minecraft.getInstance().getBlockRenderer().renderBatched(entity.getBlockState(), entity.getBlockPos(), (BlockAndTintGetter)entity.getLevel(), matrices, vertexConsumers.getBuffer(ItemBlockRenderTypes.getChunkRenderType((BlockState)entity.getBlockState())), true, entity.getLevel().random);
        matrices.popPose();
        this.spawnOrbitParticles(entity.getLevel(), new Vec3((double)entity.getBlockPos().getX() + 0.5, (double)entity.getBlockPos().getY() + 0.5, (double)entity.getBlockPos().getZ() + 0.5));
    }

    private void spawnOrbitParticles(Level level, Vec3 itemPos) {
        if (level == null) {
            return;
        }
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        int particleCount = 1;
        double radiusMin = 0.5;
        double radiusMax = 2.0;
        double orbitSpeed = 0.02;
        double heightVariation = 0.3;
        for (int i = 0; i < particleCount; ++i) {
            double angle = this.random.nextDouble() * Math.PI * 2.0;
            double radius = radiusMin + this.random.nextDouble() * (radiusMax - radiusMin);
            double xH = itemPos.x + Math.cos(angle) * radius;
            double zH = itemPos.z + Math.sin(angle) * radius;
            double yH = itemPos.y - 0.1 + this.random.nextDouble() * heightVariation;
            double vxH = -Math.sin(angle) * orbitSpeed;
            double vzH = Math.cos(angle) * orbitSpeed;
            double vyH = 0.0;
            level.addParticle((ParticleOptions)SFParticles.PEDESTAL_ITEM.get(), xH, yH, zH, vxH, vyH, vzH);
        }
    }

    public boolean shouldRenderOffScreen(StarBlockEntity p_112138_) {
        return true;
    }

    public int getViewDistance() {
        return 256;
    }

    public boolean shouldRender(StarBlockEntity entity, Vec3 vec3) {
        return Vec3.atCenterOf((Vec3i)entity.getBlockPos()).multiply(1.0, 0.0, 1.0).closerThan((Position)vec3.multiply(1.0, 0.0, 1.0), (double)this.getViewDistance());
    }

    public AABB getRenderBoundingBox(StarBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)pos.getX() + 1.0, 1024.0, (double)pos.getZ() + 1.0);
    }
}

