/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.starforge.block.entity;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.core.block.entity.handler.IInventoryHandlingBlockEntity;
import com.benbenlaw.core.block.entity.handler.InputOutputItemHandler;
import com.benbenlaw.starforge.block.SFBlockEntities;
import com.benbenlaw.starforge.block.custom.StarBlock;
import com.benbenlaw.starforge.block.entity.PedestalBlockEntity;
import com.benbenlaw.starforge.block.entity.StarBlockEntity;
import com.benbenlaw.starforge.config.SFConfig;
import com.benbenlaw.starforge.recipe.StarForgeRecipe;
import com.benbenlaw.starforge.recipe.StarForgeRecipeInput;
import com.benbenlaw.starforge.util.SFTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class StarForgeBlockEntity
extends SyncableBlockEntity
implements IInventoryHandlingBlockEntity {
    private int starPower;
    public boolean isCharging;
    public int progress;
    public int maxProgress;
    boolean isCrafting = false;
    private RecipeHolder<StarForgeRecipe> currentRecipe = null;
    private List<BlockPos> activePedestalPositions = new ArrayList<BlockPos>();
    private ItemStack incomingOutput;
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            StarForgeBlockEntity.this.progress = 0;
            StarForgeBlockEntity.this.setChanged();
            StarForgeBlockEntity.this.sync();
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private final IItemHandler forgeItemHandler = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 1);

    public StarForgeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SFBlockEntities.STAR_FORGE_BLOCK_ENTITY.get(), pos, state);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        return this.forgeItemHandler;
    }

    public void tick() {
        boolean canCraft;
        Level level = this.getLevel();
        assert (level != null);
        if (level.isClientSide()) {
            return;
        }
        this.charge(level);
        if (this.currentRecipe == null || !this.matchingRecipe(level).map(r -> ((StarForgeRecipe)r.value()).equals(this.currentRecipe.value())).orElse(false).booleanValue()) {
            this.currentRecipe = this.matchingRecipe(level).orElse(null);
            this.progress = 0;
        }
        int forgeTier = this.getStructureTier(level);
        boolean bl = canCraft = this.currentRecipe != null && this.canInsertResult(this.currentRecipe) && forgeTier >= ((StarForgeRecipe)this.currentRecipe.value()).tier() && this.starPower >= ((StarForgeRecipe)this.currentRecipe.value()).starPower();
        if (canCraft) {
            if (!this.isCrafting) {
                this.isCrafting = true;
                this.progress = 0;
                this.maxProgress = ((StarForgeRecipe)this.currentRecipe.value()).duration();
                this.activePedestalPositions.clear();
                if (((StarForgeRecipe)this.currentRecipe.value()).extraIngredients().isPresent()) {
                    List<PedestalBlockEntity> pedestals = this.getNearbyPedestals(level);
                    List<Ingredient> extras = ((StarForgeRecipe)this.currentRecipe.value()).extraIngredients().get();
                    block0: for (Ingredient extra : extras) {
                        for (PedestalBlockEntity pedestal : pedestals) {
                            ItemStack stack = pedestal.getItemStackHandler().getStackInSlot(0);
                            if (!extra.test(stack) || this.activePedestalPositions.contains(pedestal.getBlockPos())) continue;
                            this.activePedestalPositions.add(pedestal.getBlockPos());
                            continue block0;
                        }
                    }
                }
            }
            ++this.progress;
            if (this.progress == 1) {
                level.playSound(null, this.worldPosition, SoundEvents.BEACON_ACTIVATE, SoundSource.BLOCKS, 0.5f, 0.3f);
            }
            if (this.progress == 20) {
                level.playSound(null, this.worldPosition, SoundEvents.BEACON_AMBIENT, SoundSource.BLOCKS, 0.5f, 0.3f);
            }
            this.sync();
            if (this.progress >= this.maxProgress) {
                this.itemHandler.extractItem(0, 1, false);
                for (BlockPos pos : this.activePedestalPositions) {
                    BlockEntity blockEntity = level.getBlockEntity(pos);
                    if (!(blockEntity instanceof PedestalBlockEntity)) continue;
                    PedestalBlockEntity pedestal = (PedestalBlockEntity)blockEntity;
                    pedestal.getItemStackHandler().extractItem(0, 1, false);
                    pedestal.setChanged();
                }
                this.itemHandler.insertItem(1, ((StarForgeRecipe)this.currentRecipe.value()).result().copy(), false);
                this.starPower -= ((StarForgeRecipe)this.currentRecipe.value()).starPower();
                level.playSound(null, this.worldPosition, SoundEvents.BEACON_POWER_SELECT, SoundSource.BLOCKS, 0.5f, 0.3f);
                this.progress = 0;
                this.maxProgress = 0;
                this.isCrafting = false;
                this.currentRecipe = null;
                this.activePedestalPositions.clear();
            }
        } else {
            this.isCrafting = false;
            this.progress = 0;
            this.maxProgress = 0;
            this.currentRecipe = null;
            this.activePedestalPositions.clear();
        }
        this.setChanged();
        this.sync();
    }

    private boolean canInsertResult(RecipeHolder<StarForgeRecipe> recipeHolder) {
        ItemStack resultStack = ((StarForgeRecipe)recipeHolder.value()).result();
        ItemStack outputStack = this.itemHandler.getStackInSlot(1);
        if (outputStack.isEmpty()) {
            return true;
        }
        if (outputStack.getItem() == resultStack.getItem()) {
            int combinedCount = outputStack.getCount() + resultStack.getCount();
            return combinedCount <= outputStack.getMaxStackSize();
        }
        return false;
    }

    public Optional<RecipeHolder<StarForgeRecipe>> matchingRecipe(Level level) {
        if (level == null) {
            return Optional.empty();
        }
        RecipeManager recipeManager = level.getRecipeManager();
        StarForgeRecipeInput recipeInput = new StarForgeRecipeInput(this.itemHandler);
        List<PedestalBlockEntity> pedestals = this.getNearbyPedestals(level);
        List<ItemStack> pedestalItems = pedestals.stream().map(pedestalBlockEntity -> pedestalBlockEntity.getItemStackHandler().getStackInSlot(0)).toList();
        return recipeManager.getAllRecipesFor((RecipeType)StarForgeRecipe.Type.INSTANCE).stream().filter(recipe -> {
            if (!((StarForgeRecipe)recipe.value()).input().test(recipeInput.getItem(0))) {
                return false;
            }
            this.incomingOutput = ((StarForgeRecipe)recipe.value()).result();
            if (((StarForgeRecipe)recipe.value()).extraIngredients().isPresent()) {
                ArrayList extras = new ArrayList(((StarForgeRecipe)recipe.value()).extraIngredients().get());
                ArrayList available = new ArrayList(pedestalItems);
                for (Ingredient extra : extras) {
                    boolean matched = false;
                    for (ItemStack stack : available) {
                        if (!extra.test(stack)) continue;
                        matched = true;
                        available.remove(stack);
                        break;
                    }
                    if (matched) continue;
                    return false;
                }
            }
            return true;
        }).findFirst();
    }

    public void charge(Level level) {
        if (level == null) {
            return;
        }
        BlockPos starPos = this.worldPosition.above(4);
        BlockState starBlockState = level.getBlockState(starPos);
        int tier = this.getStructureTier(level);
        if (tier == -1) {
            this.isCharging = false;
            return;
        }
        if (!(starBlockState.getBlock() instanceof StarBlock)) {
            this.isCharging = false;
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(starPos);
        if (!(blockEntity instanceof StarBlockEntity)) {
            this.isCharging = false;
            return;
        }
        StarBlockEntity starEntity = (StarBlockEntity)blockEntity;
        int maxForgePower = this.getMaxStarPower(tier);
        int remainingCapacity = maxForgePower - this.starPower;
        if (remainingCapacity <= 0) {
            this.isCharging = false;
            return;
        }
        int amountToExtract = Math.min(starEntity.getTransferRate(), remainingCapacity);
        int extracted = starEntity.extractPower(amountToExtract);
        this.starPower += extracted;
        this.isCharging = extracted > 0;
        this.setChanged();
        this.sync();
    }

    public int getStructureTier(Level level) {
        for (int t = 5; t >= 1; --t) {
            if (!this.checkStructure(level, t)) continue;
            return t;
        }
        if (this.checkStructure(level, 0)) {
            return 0;
        }
        return -1;
    }

    public boolean checkStructure(Level level, int tier) {
        if (level == null) {
            return false;
        }
        BlockPos forgePos = this.worldPosition;
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                BlockPos pos;
                if (x == 0 && z == 0 || level.getBlockState(pos = forgePos.offset(x, -1, z)).is(SFTags.Blocks.STAR_FORGE_BASE_BLOCKS)) continue;
                return false;
            }
        }
        int[] xs = new int[]{-3, 3};
        int[] zs = new int[]{-3, 3};
        for (int xCorner : xs) {
            for (int zCorner : zs) {
                for (int y = 0; y < 4; ++y) {
                    BlockPos pillarPos = forgePos.offset(xCorner, y - 1, zCorner);
                    if (level.getBlockState(pillarPos).is(SFTags.Blocks.STAR_FORGE_PILLAR_BLOCKS)) continue;
                    return false;
                }
            }
        }
        if (tier >= 1) {
            for (int xCorner : xs) {
                for (int zCorner : zs) {
                    boolean validCap;
                    BlockPos capPos = forgePos.offset(xCorner, 3, zCorner);
                    switch (tier) {
                        case 1: {
                            boolean bl = level.getBlockState(capPos).is(SFTags.Blocks.STAR_FORGE_TIER_1_CAP);
                            break;
                        }
                        case 2: {
                            boolean bl = level.getBlockState(capPos).is(SFTags.Blocks.STAR_FORGE_TIER_2_CAP);
                            break;
                        }
                        case 3: {
                            boolean bl = level.getBlockState(capPos).is(SFTags.Blocks.STAR_FORGE_TIER_3_CAP);
                            break;
                        }
                        case 4: {
                            boolean bl = level.getBlockState(capPos).is(SFTags.Blocks.STAR_FORGE_TIER_4_CAP);
                            break;
                        }
                        case 5: {
                            boolean bl = level.getBlockState(capPos).is(SFTags.Blocks.STAR_FORGE_TIER_5_CAP);
                            break;
                        }
                        default: {
                            boolean bl = validCap = false;
                        }
                    }
                    if (validCap) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void rightClick(Player player) {
        ItemStack heldItem = player.getMainHandItem();
        if (heldItem.is(Items.STICK)) {
            player.sendSystemMessage(Component.nullToEmpty((String)(this.starPower + "/" + this.getMaxStarPower(this.getStructureTier(this.level)))));
            return;
        }
        ItemStack outputStack = this.itemHandler.getStackInSlot(1);
        ItemStack inputStack = this.itemHandler.getStackInSlot(0);
        ItemStack extracted = ItemStack.EMPTY;
        if (!outputStack.isEmpty()) {
            extracted = this.itemHandler.extractItem(1, 1, false);
        } else if (!inputStack.isEmpty()) {
            extracted = this.itemHandler.extractItem(0, 1, false);
        }
        if (!extracted.isEmpty()) {
            if (heldItem.isEmpty()) {
                player.setItemInHand(InteractionHand.MAIN_HAND, extracted);
            } else {
                boolean added = player.getInventory().add(extracted);
                if (!added) {
                    player.drop(extracted, false);
                }
            }
            this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.5f, 1.0f);
            this.setChanged();
            this.sync();
            return;
        }
        if (!heldItem.isEmpty()) {
            ItemStack toInsert = heldItem.copy();
            toInsert.setCount(1);
            ItemStack remaining = this.itemHandler.insertItem(0, toInsert, false);
            if (remaining.isEmpty()) {
                heldItem.shrink(1);
                player.setItemInHand(player.getUsedItemHand(), heldItem);
                this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.5f, 1.0f);
                this.setChanged();
                this.sync();
            }
        }
    }

    public int getMaxStarPower(int tier) {
        return switch (tier) {
            case 1 -> (Integer)SFConfig.forgeCapacityCap1.get();
            case 2 -> (Integer)SFConfig.forgeCapacityCap2.get();
            case 3 -> (Integer)SFConfig.forgeCapacityCap3.get();
            case 4 -> (Integer)SFConfig.forgeCapacityCap4.get();
            case 5 -> (Integer)SFConfig.forgeCapacityCap5.get();
            default -> (Integer)SFConfig.forgeCapacity.get();
        };
    }

    private List<PedestalBlockEntity> getNearbyPedestals(Level level) {
        ArrayList<PedestalBlockEntity> pedestals = new ArrayList<PedestalBlockEntity>();
        BlockPos forgePos = this.worldPosition;
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                BlockPos checkPos = forgePos.offset(x, 0, z);
                BlockEntity blockEntity = level.getBlockEntity(checkPos);
                if (!(blockEntity instanceof PedestalBlockEntity)) continue;
                PedestalBlockEntity pedestal = (PedestalBlockEntity)blockEntity;
                pedestals.add(pedestal);
            }
        }
        return pedestals;
    }

    public List<BlockPos> getActivePedestalPositions() {
        return this.activePedestalPositions;
    }

    public int getStarPower() {
        return this.starPower;
    }

    public boolean isCrafting() {
        return this.isCrafting;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public ItemStack getIncomingOutput() {
        return this.incomingOutput;
    }

    public void setHandler(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        tag.putInt("starPower", this.starPower);
        tag.putBoolean("isCharging", this.isCharging);
        tag.putInt("progress", this.progress);
        tag.putInt("maxProgress", this.maxProgress);
        tag.putBoolean("isCrafting", this.isCrafting);
        ListTag posList = new ListTag();
        for (BlockPos pos : this.activePedestalPositions) {
            CompoundTag posTag = new CompoundTag();
            posTag.put("pos", NbtUtils.writeBlockPos((BlockPos)pos));
            posList.add((Object)posTag);
        }
        tag.put("activePedestalPositions", (Tag)posList);
        if (this.incomingOutput != null && !this.incomingOutput.isEmpty()) {
            tag.put("incomingOutput", this.incomingOutput.save(provider));
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.itemHandler.deserializeNBT(provider, tag.getCompound("inventory"));
        this.starPower = tag.getInt("starPower");
        this.isCharging = tag.getBoolean("isCharging");
        this.progress = tag.getInt("progress");
        this.maxProgress = tag.getInt("maxProgress");
        this.isCrafting = tag.getBoolean("isCrafting");
        this.incomingOutput = tag.contains("incomingOutput", 10) ? (ItemStack)ItemStack.parse((HolderLookup.Provider)provider, (Tag)tag.getCompound("incomingOutput")).get() : ItemStack.EMPTY;
        this.activePedestalPositions.clear();
        ListTag posList = tag.getList("activePedestalPositions", 10);
        for (int i = 0; i < posList.size(); ++i) {
            CompoundTag posTag = posList.getCompound(i);
            NbtUtils.readBlockPos((CompoundTag)posTag, (String)"pos").ifPresent(this.activePedestalPositions::add);
        }
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }
}

