/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.starforge.block.entity;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.starforge.block.SFBlockEntities;
import com.benbenlaw.starforge.block.custom.StarBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class StarBlockEntity
extends SyncableBlockEntity {
    private int transferRate;
    private int starPowerCapacity;
    private int starPower;

    public StarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SFBlockEntities.STAR_BLOCK_ENTITY.get(), pos, state);
        this.transferRate = ((StarBlock)state.getBlock()).getTransferRate();
        this.starPowerCapacity = ((StarBlock)state.getBlock()).getStarPowerCapacity();
    }

    public void tick() {
        Level level = this.getLevel();
        if (level == null || level.isClientSide()) {
            return;
        }
        BlockPos abovePos = this.worldPosition.above();
        if (level.isNight() && level.canSeeSky(abovePos)) {
            this.charge();
        }
    }

    public void charge() {
        if (this.starPower < this.starPowerCapacity) {
            this.starPower += this.transferRate;
            if (this.starPower > this.starPowerCapacity) {
                this.starPower = this.starPowerCapacity;
            }
            this.setChanged();
        }
    }

    public int extractPower(int amount) {
        int extracted = Math.min(amount, this.starPower);
        this.starPower -= extracted;
        if (this.starPower < 0) {
            this.starPower = 0;
        }
        this.setChanged();
        return extracted;
    }

    public int getStarPower() {
        return this.starPower;
    }

    public int getTransferRate() {
        return this.transferRate;
    }

    public void rightClick(Player player) {
        ItemStack heldItem = player.getMainHandItem();
        if (heldItem.is(Items.STICK)) {
            player.sendSystemMessage(Component.nullToEmpty((String)(this.starPower + "/" + this.starPowerCapacity)));
            player.sendSystemMessage(Component.nullToEmpty((String)(this.transferRate + " SP/t")));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("starPower", this.starPower);
        tag.putInt("transferRate", this.transferRate);
        tag.putInt("starPowerCapacity", this.starPowerCapacity);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.starPower = tag.getInt("starPower");
        this.transferRate = tag.getInt("transferRate");
        this.starPowerCapacity = tag.getInt("starPowerCapacity");
    }
}

