/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.starforge.block.entity;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.core.block.entity.handler.IInventoryHandlingBlockEntity;
import com.benbenlaw.core.block.entity.handler.InputOutputItemHandler;
import com.benbenlaw.starforge.block.SFBlockEntities;
import com.benbenlaw.starforge.block.entity.StarForgeBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class PedestalBlockEntity
extends SyncableBlockEntity
implements IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            PedestalBlockEntity.this.setChanged();
            PedestalBlockEntity.this.sync();
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private final IItemHandler pedestalItemHandler = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> false);

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        return this.pedestalItemHandler;
    }

    public PedestalBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SFBlockEntities.PEDESTAL_BLOCK_ENTITY.get(), pos, state);
    }

    public void tick() {
    }

    public void rightClick(Player player) {
        ItemStack extracted;
        ItemStack heldItem = player.getMainHandItem();
        assert (this.level != null);
        if (!heldItem.isEmpty()) {
            ItemStack toInsert = heldItem.copy();
            toInsert.setCount(1);
            ItemStack remaining = this.itemHandler.insertItem(0, toInsert, false);
            if (remaining.isEmpty()) {
                heldItem.shrink(1);
                player.setItemInHand(player.getUsedItemHand(), heldItem);
                this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.5f, 1.0f);
                this.setChanged();
                this.sync();
                return;
            }
        }
        if (!(extracted = this.itemHandler.extractItem(0, 1, false)).isEmpty()) {
            if (heldItem.isEmpty()) {
                player.setItemInHand(InteractionHand.MAIN_HAND, extracted);
            } else {
                boolean added = player.getInventory().add(extracted);
                if (!added) {
                    player.drop(extracted, false);
                }
            }
            this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.5f, 1.0f);
            this.setChanged();
            this.sync();
        }
    }

    public StarForgeBlockEntity findNearbyForge() {
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                BlockPos pos = this.worldPosition.offset(x, 0, z);
                BlockEntity blockEntity = this.level.getBlockEntity(pos);
                if (!(blockEntity instanceof StarForgeBlockEntity)) continue;
                StarForgeBlockEntity forge = (StarForgeBlockEntity)blockEntity;
                return forge;
            }
        }
        return null;
    }

    public void setHandler(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.itemHandler.deserializeNBT(provider, tag.getCompound("inventory"));
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }
}

