/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.starforge.block.custom;

import com.benbenlaw.starforge.block.SFBlockEntities;
import com.benbenlaw.starforge.block.entity.StarForgeBlockEntity;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StarForgeBlock
extends BaseEntityBlock {
    public static final MapCodec<StarForgeBlock> CODEC = StarForgeBlock.simpleCodec(StarForgeBlock::new);
    private static VoxelShape SHAPE = Shapes.empty();

    public StarForgeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.getBlock() != pNewState.getBlock() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof StarForgeBlockEntity) {
            ((StarForgeBlockEntity)blockEntity).drops();
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    protected VoxelShape getShape(BlockState p_334026_, BlockGetter p_334049_, BlockPos p_334056_, CollisionContext p_333870_) {
        return SHAPE;
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull BlockHitResult hit) {
        BlockEntity entity = level.getBlockEntity(blockPos);
        if (!level.isClientSide() && entity instanceof StarForgeBlockEntity) {
            StarForgeBlockEntity starForgeBlockEntity = (StarForgeBlockEntity)entity;
            starForgeBlockEntity.rightClick(player);
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new StarForgeBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        return StarForgeBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)SFBlockEntities.STAR_FORGE_BLOCK_ENTITY.get()), (world, blockPos, thisBlockState, blockEntity) -> blockEntity.tick());
    }

    static {
        SHAPE = Shapes.join((VoxelShape)SHAPE, (VoxelShape)Shapes.box((double)0.25, (double)0.0625, (double)0.25, (double)0.75, (double)0.1875, (double)0.75), (BooleanOp)BooleanOp.OR);
        SHAPE = Shapes.join((VoxelShape)SHAPE, (VoxelShape)Shapes.box((double)0.1875, (double)0.4375, (double)0.1875, (double)0.8125, (double)0.5625, (double)0.8125), (BooleanOp)BooleanOp.OR);
        SHAPE = Shapes.join((VoxelShape)SHAPE, (VoxelShape)Shapes.box((double)0.0625, (double)0.5625, (double)0.0625, (double)0.9375, (double)0.875, (double)0.9375), (BooleanOp)BooleanOp.OR);
        SHAPE = Shapes.join((VoxelShape)SHAPE, (VoxelShape)Shapes.box((double)0.1875, (double)0.3125, (double)0.1875, (double)0.8125, (double)0.4375, (double)0.8125), (BooleanOp)BooleanOp.OR);
        SHAPE = Shapes.join((VoxelShape)SHAPE, (VoxelShape)Shapes.box((double)0.25, (double)0.1875, (double)0.25, (double)0.75, (double)0.3125, (double)0.75), (BooleanOp)BooleanOp.OR);
        SHAPE = Shapes.join((VoxelShape)SHAPE, (VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.0625, (double)0.8125), (BooleanOp)BooleanOp.OR);
        SHAPE = Shapes.join((VoxelShape)SHAPE, (VoxelShape)Shapes.box((double)0.0625, (double)0.375, (double)0.0625, (double)0.125, (double)0.5625, (double)0.125), (BooleanOp)BooleanOp.OR);
        SHAPE = Shapes.join((VoxelShape)SHAPE, (VoxelShape)Shapes.box((double)0.875, (double)0.375, (double)0.0625, (double)0.9375, (double)0.5625, (double)0.125), (BooleanOp)BooleanOp.OR);
        SHAPE = Shapes.join((VoxelShape)SHAPE, (VoxelShape)Shapes.box((double)0.875, (double)0.375, (double)0.875, (double)0.9375, (double)0.5625, (double)0.9375), (BooleanOp)BooleanOp.OR);
        SHAPE = Shapes.join((VoxelShape)SHAPE, (VoxelShape)Shapes.box((double)0.0625, (double)0.375, (double)0.875, (double)0.125, (double)0.5625, (double)0.9375), (BooleanOp)BooleanOp.OR);
    }
}

