/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.starforge.block.custom;

import com.benbenlaw.starforge.block.SFBlockEntities;
import com.benbenlaw.starforge.block.entity.StarBlockEntity;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StarBlock
extends BaseEntityBlock {
    public static final MapCodec<StarBlock> CODEC = StarBlock.simpleCodec(props -> new StarBlock((BlockBehaviour.Properties)props, 0, 0, 0xFFFFFF));
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private final int transferRate;
    private final int starPowerCapacity;
    private final int color;

    public StarBlock(BlockBehaviour.Properties properties, int transferRate, int starPowerCapacity, int color) {
        super(properties);
        this.transferRate = transferRate;
        this.starPowerCapacity = starPowerCapacity;
        this.color = color;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public void appendHoverText(ItemStack itemStack, @NotNull Item.TooltipContext context, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.literal((String)("Star Capacity: " + this.getStarPowerCapacity())).withStyle(ChatFormatting.YELLOW));
            components.add((Component)Component.literal((String)("Star Power Transfer Per Tick: " + this.getTransferRate())).withStyle(ChatFormatting.YELLOW));
        } else {
            components.add((Component)Component.translatable((String)"tooltips.bblcore.shift").withStyle(ChatFormatting.YELLOW));
        }
        super.appendHoverText(itemStack, context, components, flag);
    }

    public int getTransferRate() {
        return this.transferRate;
    }

    public int getStarPowerCapacity() {
        return this.starPowerCapacity;
    }

    public int getColor() {
        return this.color;
    }

    protected VoxelShape getShape(BlockState p_334026_, BlockGetter p_334049_, BlockPos p_334056_, CollisionContext p_333870_) {
        return SHAPE;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState pState) {
        return RenderShape.INVISIBLE;
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull BlockHitResult hit) {
        BlockEntity entity = level.getBlockEntity(blockPos);
        if (!level.isClientSide() && entity instanceof StarBlockEntity) {
            StarBlockEntity starBlockEntity = (StarBlockEntity)entity;
            starBlockEntity.rightClick(player);
        }
        return InteractionResult.CONSUME;
    }

    public void onRemove(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new StarBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        return StarBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)SFBlockEntities.STAR_BLOCK_ENTITY.get()), (world, blockPos, thisBlockState, blockEntity) -> blockEntity.tick());
    }
}

