/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.starforge.block;

import com.benbenlaw.starforge.block.custom.CapBlock;
import com.benbenlaw.starforge.block.custom.PedestalBlock;
import com.benbenlaw.starforge.block.custom.StarBlock;
import com.benbenlaw.starforge.block.custom.StarForgeBlock;
import com.benbenlaw.starforge.item.SFItems;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class SFBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.createBlocks((String)"starforge");
    public static final DeferredBlock<Block> BLUE_STAR = SFBlocks.registerBlock("blue_star", () -> new StarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).lightLevel(state -> 15), 1, 4000, 329187));
    public static final DeferredBlock<Block> WHITE_STAR = SFBlocks.registerBlock("white_star", () -> new StarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).lightLevel(state -> 15), 2, 8000, 0xDFDFDF));
    public static final DeferredBlock<Block> YELLOW_STAR = SFBlocks.registerBlock("yellow_star", () -> new StarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).lightLevel(state -> 15), 4, 16000, 14929157));
    public static final DeferredBlock<Block> ORANGE_STAR = SFBlocks.registerBlock("orange_star", () -> new StarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).lightLevel(state -> 15), 8, 32000, 14905605));
    public static final DeferredBlock<Block> RED_STAR = SFBlocks.registerBlock("red_star", () -> new StarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).lightLevel(state -> 15), 20, 128000, 14877957));
    public static final DeferredBlock<Block> STAR_FORGE = SFBlocks.registerBlock("star_forge", () -> new StarForgeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final DeferredBlock<Block> PEDESTAL = SFBlocks.registerBlock("pedestal", () -> new PedestalBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final DeferredBlock<Block> COSMIC_PLANKS = SFBlocks.registerBlock("cosmic_planks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final DeferredBlock<Block> COSMIC_PILLAR = SFBlocks.registerBlock("cosmic_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final DeferredBlock<Block> TIER_1_STAR_FORGE_CAP = SFBlocks.registerBlock("tier_1_star_forge_cap", () -> new CapBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final DeferredBlock<Block> TIER_2_STAR_FORGE_CAP = SFBlocks.registerBlock("tier_2_star_forge_cap", () -> new CapBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final DeferredBlock<Block> TIER_3_STAR_FORGE_CAP = SFBlocks.registerBlock("tier_3_star_forge_cap", () -> new CapBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final DeferredBlock<Block> TIER_4_STAR_FORGE_CAP = SFBlocks.registerBlock("tier_4_star_forge_cap", () -> new CapBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final DeferredBlock<Block> TIER_5_STAR_FORGE_CAP = SFBlocks.registerBlock("tier_5_star_forge_cap", () -> new CapBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = (DeferredBlock)BLOCKS.register(name, block);
        SFBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        SFItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }
}

