/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import com.mojang.datafixers.util.Pair;
import de.ellpeck.naturesaura.entities.EntityStructureFinder;
import de.ellpeck.naturesaura.entities.ModEntities;
import de.ellpeck.naturesaura.items.ItemImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;

public class ItemStructureFinder
extends ItemImpl {
    private final ResourceKey<Structure> structure;
    private final int color;

    public ItemStructureFinder(String baseName, ResourceKey<Structure> structure, int color) {
        super(baseName);
        this.structure = structure;
        this.color = color;
    }

    public InteractionResultHolder<ItemStack> use(Level levelIn, Player playerIn, InteractionHand handIn) {
        Pair pos;
        Registry registry;
        HolderSet.Direct holderSet;
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (!levelIn.isClientSide && ((ServerLevel)levelIn).structureManager().shouldGenerateStructures() && (holderSet = (HolderSet.Direct)(registry = levelIn.registryAccess().registryOrThrow(Registries.STRUCTURE)).getHolder(this.structure).map(xva$0 -> HolderSet.direct((Holder[])new Holder[]{xva$0})).orElse(null)) != null && (pos = ((ServerLevel)levelIn).getChunkSource().getGenerator().findNearestMapStructure((ServerLevel)levelIn, (HolderSet)holderSet, playerIn.blockPosition(), 100, false)) != null) {
            EntityStructureFinder entity = new EntityStructureFinder(ModEntities.STRUCTURE_FINDER, levelIn);
            entity.setPos(playerIn.getX(), playerIn.getY(0.5), playerIn.getZ());
            entity.setItem(stack);
            entity.getEntityData().set(EntityStructureFinder.COLOR, (Object)this.color);
            entity.signalTo(((BlockPos)pos.getFirst()).above(64));
            levelIn.addFreshEntity((Entity)entity);
            stack.shrink(1);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }
}

