/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.util.game;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public class TextProcessor {
    public static final TextProcessor INSTANCE = new TextProcessor();
    private static final Pattern CONTROL_PATTERN = Pattern.compile("\\$\\(((?:(?:\\w+|#[0-9A-Fa-f]{6})(?:;(?:\\w+|#[0-9A-Fa-f]{6}))*)?)\\)");

    public List<Component> process(Component text) {
        return this.process(text.getString());
    }

    public List<Component> process(String text) {
        return (List)Arrays.stream(text.split("\\$\\((?:n|newline)\\)")).map(String::trim).map(this::processLine).collect(ImmutableList.toImmutableList());
    }

    public Component processLine(Component line) {
        return this.processLine(line.getString());
    }

    public Component processLine(String line) {
        if (line.isEmpty()) {
            return Component.empty();
        }
        Matcher m = CONTROL_PATTERN.matcher(line);
        MutableComponent tc = Component.empty();
        int idx = 0;
        Style style = Style.EMPTY;
        while (m.find()) {
            if (idx < m.start()) {
                tc.append((Component)Component.literal((String)line.substring(idx, m.start())).withStyle(style));
            }
            idx = m.end();
            String cmd = m.group(1).trim();
            if (cmd.isEmpty()) {
                style = Style.EMPTY;
                continue;
            }
            block3: for (String part : cmd.split(";")) {
                if (part.startsWith("#")) {
                    try {
                        int color = Integer.parseInt(part.substring(1), 16);
                        style = style.withColor(TextColor.fromRgb((int)color));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ("b".equalsIgnoreCase(part.strip()) || "bold".equalsIgnoreCase(part.strip())) {
                    style = style.withBold(Boolean.valueOf(true));
                    continue;
                }
                if ("i".equalsIgnoreCase(part.strip()) || "italic".equalsIgnoreCase(part.strip())) {
                    style = style.withItalic(Boolean.valueOf(true));
                    continue;
                }
                if ("u".equalsIgnoreCase(part.strip()) || "underline".equalsIgnoreCase(part.strip())) {
                    style = style.withUnderlined(Boolean.valueOf(true));
                    continue;
                }
                if ("s".equalsIgnoreCase(part.strip()) || "strikethrough".equalsIgnoreCase(part.strip())) {
                    style = style.withStrikethrough(Boolean.valueOf(true));
                    continue;
                }
                for (ChatFormatting tf : ChatFormatting.values()) {
                    if (!tf.getName().equalsIgnoreCase(part.strip())) continue;
                    style = style.withColor(tf);
                    continue block3;
                }
                style = this.customCommand(style, part.strip());
            }
        }
        if (idx < line.length()) {
            tc.append((Component)Component.literal((String)line.substring(idx)).withStyle(style));
        }
        return tc;
    }

    public Style customCommand(Style style, String command) {
        return style;
    }
}

