/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.util.game;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ComponentUtil {
    private static final HoverEvent HOVER_COPY = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"libx.misc.copy"));

    public static String getConsoleString(Component tc) {
        StringBuilder sb = new StringBuilder();
        tc.visit((style, string) -> {
            ComponentUtil.reset(sb);
            ComponentUtil.formattingCodes(sb, style);
            sb.append(string);
            return Optional.empty();
        }, Style.EMPTY);
        ComponentUtil.reset(sb);
        return sb.toString();
    }

    private static void formattingCodes(StringBuilder sb, Style style) {
        if (style.getColor() != null) {
            int color = style.getColor().getValue();
            sb.append("\u001b[38;2;").append(color >> 16 & 0xFF).append(";").append(color >> 8 & 0xFF).append(";").append(color & 0xFF).append("m");
        }
        if (style.bold != null) {
            if (style.bold.booleanValue()) {
                sb.append("\u001b[1m");
            } else {
                sb.append("\u001b[22m");
            }
        }
        if (style.italic != null) {
            if (style.italic.booleanValue()) {
                sb.append("\u001b[3m");
            } else {
                sb.append("\u001b[23m");
            }
        }
        if (style.underlined != null) {
            if (style.underlined.booleanValue()) {
                sb.append("\u001b[4m");
            } else {
                sb.append("\u001b[24m");
            }
        }
        if (style.strikethrough != null) {
            if (style.strikethrough.booleanValue()) {
                sb.append("\u001b[9m");
            } else {
                sb.append("\u001b[29m");
            }
        }
        if (style.obfuscated != null) {
            if (style.obfuscated.booleanValue()) {
                sb.append("\u001b[8m");
            } else {
                sb.append("\u001b[28m");
            }
        }
    }

    private static void reset(StringBuilder sb) {
        sb.append("\u001b[0m");
    }

    public static Component toPrettyComponent(JsonElement json) {
        if (json.isJsonNull()) {
            return Component.literal((String)"null").withStyle(ChatFormatting.RED);
        }
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (primitive.isString()) {
                return Component.literal((String)primitive.toString()).withStyle(ChatFormatting.GREEN);
            }
            return Component.literal((String)primitive.toString()).withStyle(ChatFormatting.GOLD);
        }
        if (json instanceof JsonArray) {
            JsonArray array = (JsonArray)json;
            MutableComponent tc = Component.literal((String)"[");
            boolean first = true;
            for (JsonElement element : array) {
                if (first) {
                    first = false;
                } else {
                    tc.append((Component)Component.literal((String)", "));
                }
                tc = tc.append(ComponentUtil.toPrettyComponent(element));
            }
            tc = tc.append((Component)Component.literal((String)"]"));
            return tc;
        }
        if (json instanceof JsonObject) {
            JsonObject object = (JsonObject)json;
            MutableComponent tc = Component.literal((String)"{");
            boolean first = true;
            for (Map.Entry entry : object.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    tc.append((Component)Component.literal((String)", "));
                }
                tc = tc.append((Component)Component.literal((String)new JsonPrimitive((String)entry.getKey()).toString()).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)": ")).append(ComponentUtil.toPrettyComponent((JsonElement)entry.getValue()));
            }
            tc = tc.append((Component)Component.literal((String)"}"));
            return tc;
        }
        throw new IllegalArgumentException("JSON type unknown: " + String.valueOf(json.getClass()));
    }

    public static Component toPrettyComponent(ResourceKey<Registry<DataComponentType<?>>> registry, RegistryAccess registryAccess, DataComponentMap components) {
        return ComponentUtil.toPrettyComponent(registry, registryAccess, components.stream().collect(Collectors.toUnmodifiableMap(TypedDataComponent::type, tc -> Optional.of(tc.value()))));
    }

    public static Component toPrettyComponent(ResourceKey<Registry<DataComponentType<?>>> registry, RegistryAccess registryAccess, DataComponentPatch patch) {
        return ComponentUtil.toPrettyComponent(registry, registryAccess, patch.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private static Component toPrettyComponent(ResourceKey<Registry<DataComponentType<?>>> registry, RegistryAccess registryAccess, Map<DataComponentType<?>, Optional<?>> map) {
        Registry theRegistry = registryAccess.registry(registry).orElse(null);
        if (theRegistry == null) {
            theRegistry = (Registry)BuiltInRegistries.REGISTRY.get(registry.location());
        }
        if (theRegistry == null) {
            throw new IllegalStateException("Registry not found: " + String.valueOf(registry));
        }
        RegistryOps registryOps = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registryAccess);
        HashMap typeMap = new HashMap();
        for (DataComponentType<?> type : map.keySet()) {
            if (type.isTransient()) continue;
            ResourceLocation id = theRegistry.getKey(type);
            if (id == null) {
                throw new IllegalStateException("Unregistered data component type: " + String.valueOf(type));
            }
            typeMap.put(id, type);
        }
        MutableComponent cmp = Component.literal((String)"[");
        boolean first = true;
        for (ResourceLocation typeId : typeMap.keySet().stream().sorted().toList()) {
            if (!first) {
                cmp = cmp.append(", ");
            }
            first = false;
            DataComponentType type = (DataComponentType)typeMap.get(typeId);
            Optional<?> maybeValue = map.get(type);
            if (maybeValue.isEmpty()) {
                cmp.append((Component)Component.literal((String)"!"));
            }
            cmp = cmp.append((Component)Component.literal((String)typeId.toString()).withStyle(ChatFormatting.DARK_RED));
            if (!maybeValue.isPresent()) continue;
            cmp = cmp.append("=");
            DataResult result = type.codecOrThrow().encodeStart((DynamicOps)registryOps, maybeValue.get());
            if (result instanceof DataResult.Error) {
                return Component.literal((String)("encoder error for " + String.valueOf(typeId))).withStyle(ChatFormatting.RED);
            }
            cmp = cmp.append(NbtUtils.toPrettyComponent((Tag)((Tag)result.getOrThrow())));
        }
        cmp = cmp.append((Component)Component.literal((String)"]"));
        return cmp;
    }

    public static Component withCopyAction(Component component, String copyText) {
        return component.copy().withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, copyText)).withHoverEvent(HOVER_COPY));
    }

    public static FormattedCharSequence subSequence(FormattedCharSequence text, int start) {
        if (start == 0) {
            return text;
        }
        return ComponentUtil.subSequence(text, start, 0x7FFFFFFE);
    }

    public static FormattedCharSequence subSequence(FormattedCharSequence text, int start, int end) {
        if (start < 0 || end < 0) {
            throw new IllegalArgumentException("Negative bounds");
        }
        if (end <= start) {
            return FormattedCharSequence.EMPTY;
        }
        return sink -> {
            AtomicInteger relOff = new AtomicInteger(0);
            AtomicInteger total = new AtomicInteger(0);
            return text.accept((relPosition, style, codePoint) -> {
                int current = total.getAndIncrement();
                if (current == start) {
                    relOff.set(-relPosition);
                } else if (relPosition == 0) {
                    relOff.set(0);
                }
                if (current >= start && current < end) {
                    return sink.accept(relPosition + relOff.get(), style, codePoint);
                }
                return true;
            });
        };
    }
}

