/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.screen.text;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.moddingx.libx.impl.screen.text.TextScreenContent;
import org.moddingx.libx.render.RenderHelper;
import org.moddingx.libx.screen.text.ComponentLayout;

public class TextScreen
extends Screen {
    private final ComponentLayout layout;
    private final int displayWidth;
    @Nullable
    private TextScreenContent content;

    public TextScreen(ComponentLayout layout) {
        this(layout, 176);
    }

    public TextScreen(ComponentLayout layout, int width) {
        super(Optional.ofNullable(layout.title()).orElse((Component)Component.empty()));
        this.layout = layout;
        this.displayWidth = width;
        this.content = null;
    }

    private int left() {
        if (this.content == null) {
            return 0;
        }
        return (this.width - this.content.width()) / 2;
    }

    private int top() {
        if (this.content == null) {
            return 0;
        }
        return (this.height - this.content.height()) / 2;
    }

    protected void init() {
        this.content = new TextScreenContent(this.font, this.displayWidth, this.layout.alignComponents(this.font, this.displayWidth));
        this.content.addWidgets(this.left(), this.top(), x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        if (this.content == null) {
            return;
        }
        int left = this.left();
        int top = this.top();
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 20.0f);
        this.drawBackground(graphics, left - 10, top - 10, this.content.width() + 20, this.content.height() + 20);
        graphics.pose().translate(0.0f, 0.0f, 100.0f);
        this.content.render(graphics, left, top);
        graphics.pose().popPose();
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 200.0f);
        for (Renderable renderable : this.renderables) {
            renderable.render(graphics, mouseX, mouseY, partialTick);
        }
        graphics.pose().popPose();
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 500.0f);
        Style tooltip = this.content.hoveredStyle(mouseX - left, mouseY - top);
        if (tooltip != null) {
            graphics.pose().translate(0.0f, 0.0f, 20.0f);
            RenderHelper.resetColor();
            graphics.renderComponentHoverEffect(this.font, tooltip, mouseX, mouseY);
        }
        graphics.pose().popPose();
    }

    protected void drawBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        RenderHelper.renderGuiBackground(graphics, x, y, width, height);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Style click;
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0 && this.content != null && (click = this.content.hoveredStyle((int)mouseX - this.left(), (int)mouseY - this.top())) != null) {
            return this.handleComponentClicked(click);
        }
        return false;
    }

    protected void insertText(@Nonnull String text, boolean overwrite) {
        Minecraft.getInstance().openChatScreen(text);
    }
}

