/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.screen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.network.chat.Component;
import org.moddingx.libx.config.gui.EditorOps;

public abstract class Panel
extends AbstractWidget
implements ContainerEventHandler,
EditorOps {
    private final List<GuiEventListener> children = new ArrayList<GuiEventListener>();
    private final List<Renderable> renderables = new ArrayList<Renderable>();
    @Nullable
    private GuiEventListener focused = null;
    private boolean dragging = false;

    public Panel(int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.empty());
    }

    protected <T extends GuiEventListener & Renderable> T addRenderableWidget(T widget) {
        this.renderables.add(widget);
        this.children.add(widget);
        return widget;
    }

    protected <T extends Renderable> T addRenderableOnly(T widget) {
        this.renderables.add(widget);
        return widget;
    }

    protected <T extends GuiEventListener> T addWidget(T widget) {
        this.children.add(widget);
        return widget;
    }

    @Nonnull
    public List<? extends GuiEventListener> children() {
        return Collections.unmodifiableList(this.children);
    }

    public final void renderWidget(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        for (Renderable widget : this.renderables) {
            widget.render(graphics, mouseX - this.getX(), mouseY - this.getY(), partialTicks);
        }
        graphics.pose().popPose();
        this.renderWidgetContent(graphics, mouseX, mouseY, partialTicks);
    }

    protected void renderWidgetContent(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    @Nonnull
    public Optional<GuiEventListener> getChildAt(double mouseX, double mouseY) {
        return super.getChildAt(mouseX - (double)this.getX(), mouseY - (double)this.getY());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (GuiEventListener child : this.children) {
            if (!child.mouseClicked(mouseX - (double)this.getX(), mouseY - (double)this.getY(), button)) continue;
            this.setFocused(child);
            if (button == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.setDragging(false);
        return this.getChildAt(mouseX, mouseY).filter(child -> child.mouseReleased(mouseX - (double)this.getX(), mouseY - (double)this.getY(), button)).isPresent();
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.focused != null && this.dragging && button == 0 && this.focused.mouseDragged(mouseX - (double)this.getX(), mouseY - (double)this.getY(), button, dragX - (double)this.getX(), dragY - (double)this.getY());
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return this.getChildAt(mouseX, mouseY).filter(child -> child.mouseScrolled(mouseX - (double)this.getX(), mouseY - (double)this.getY(), scrollX, scrollY)).isPresent();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char value, int modifiers) {
        return super.charTyped(value, modifiers);
    }

    public void updateWidgetNarration(@Nonnull NarrationElementOutput output) {
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
        this.updateChildFocus();
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.focused;
    }

    public void setFocused(@Nullable GuiEventListener focused) {
        this.focused = this.children.contains(focused) ? focused : null;
        this.setFocused(focused != null);
    }

    private void updateChildFocus() {
        for (GuiEventListener child : this.children) {
            boolean shouldBeFocused;
            boolean bl = shouldBeFocused = this.isFocused() && child == this.focused;
            if (child.isFocused() == shouldBeFocused) continue;
            child.setFocused(shouldBeFocused);
        }
    }

    @Nullable
    public ComponentPath getCurrentFocusPath() {
        return super.getCurrentFocusPath();
    }

    @Nullable
    public ComponentPath nextFocusPath(@Nonnull FocusNavigationEvent event) {
        return super.nextFocusPath(event);
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    @Override
    public void enabled(boolean enabled) {
        for (GuiEventListener child : this.children) {
            EditorOps.wrap(child).enabled(enabled);
        }
    }
}

