/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.sandbox.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class InvertPlacementFilter
extends PlacementFilter {
    public static final MapCodec<InvertPlacementFilter> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PlacementModifier.CODEC.fieldOf("filter").flatXmap(modifier -> {
        DataResult dataResult;
        if (modifier instanceof PlacementFilter) {
            PlacementFilter filter = (PlacementFilter)modifier;
            dataResult = DataResult.success((Object)filter);
        } else {
            dataResult = DataResult.error(() -> "Can only invert placement filters, not modifiers. Invalid filter: " + String.valueOf(modifier));
        }
        return dataResult;
    }, DataResult::success).forGetter(filter -> filter.filter)).apply((Applicative)instance, InvertPlacementFilter::new));
    public static final PlacementModifierType<InvertPlacementFilter> TYPE = () -> CODEC;
    private final PlacementFilter filter;

    public InvertPlacementFilter(PlacementFilter filter) {
        this.filter = filter;
    }

    @Nonnull
    public PlacementModifierType<?> type() {
        return TYPE;
    }

    protected boolean shouldPlace(@Nonnull PlacementContext context, @Nonnull RandomSource random, @Nonnull BlockPos pos) {
        return this.filter.getPositions(context, random, pos).findAny().isEmpty();
    }
}

