/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.sandbox.generator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.moddingx.libx.impl.sandbox.FakeHolder;
import org.moddingx.libx.sandbox.SandBox;
import org.moddingx.libx.sandbox.surface.BiomeSurface;
import org.moddingx.libx.sandbox.surface.SurfaceRuleSet;

public class ExtendedNoiseChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final MapCodec<ExtendedNoiseChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeSource.CODEC.fieldOf("biome_source").forGetter(gen -> gen.biomeSource), (App)NoiseGeneratorSettings.CODEC.fieldOf("settings").forGetter(gen -> gen.actualSettings), (App)SurfaceRuleSet.CODEC.optionalFieldOf("surface_override").forGetter(gen -> gen.surfaceOverride)).apply((Applicative)instance, ExtendedNoiseChunkGenerator::new));
    private final Optional<Holder<SurfaceRuleSet>> surfaceOverride;
    private final Holder<NoiseGeneratorSettings> actualSettings;
    private final FakeHolder<NoiseGeneratorSettings> fakeSettings;

    public ExtendedNoiseChunkGenerator(BiomeSource biomes, Holder<NoiseGeneratorSettings> settings, Optional<Holder<SurfaceRuleSet>> surfaceOverride) {
        this(biomes, settings, new FakeHolder<NoiseGeneratorSettings>(settings), surfaceOverride);
    }

    private ExtendedNoiseChunkGenerator(BiomeSource biomes, Holder<NoiseGeneratorSettings> settings, FakeHolder<NoiseGeneratorSettings> delegate, Optional<Holder<SurfaceRuleSet>> surfaceOverride) {
        super(biomes, delegate);
        this.surfaceOverride = surfaceOverride;
        this.actualSettings = settings;
        this.fakeSettings = delegate;
    }

    public void init(RegistryAccess access) {
        if (this.surfaceOverride.isPresent()) {
            NoiseGeneratorSettings settings = (NoiseGeneratorSettings)this.actualSettings.value();
            SurfaceRuleSet set = (SurfaceRuleSet)this.surfaceOverride.get().value();
            Set biomes = this.biomeSource.possibleBiomes();
            SurfaceRules.RuleSource surfaceRule = set.build((Registry<Biome>)access.registryOrThrow(Registries.BIOME), (Registry<BiomeSurface>)access.registryOrThrow(SandBox.BIOME_SURFACE), biomes, (NoiseGeneratorSettings)this.actualSettings.value());
            this.fakeSettings.set((Holder<NoiseGeneratorSettings>)Holder.direct((Object)ExtendedNoiseChunkGenerator.withSurface(settings, surfaceRule)));
        }
    }

    @Nonnull
    protected MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    @Nonnull
    public Holder<NoiseGeneratorSettings> generatorSettings() {
        return this.actualSettings;
    }

    public boolean stable(@Nonnull ResourceKey<NoiseGeneratorSettings> settings) {
        return this.actualSettings.is(settings);
    }

    private static NoiseGeneratorSettings withSurface(NoiseGeneratorSettings settings, SurfaceRules.RuleSource surfaceRule) {
        return new NoiseGeneratorSettings(settings.noiseSettings(), settings.defaultBlock(), settings.defaultFluid(), settings.noiseRouter(), surfaceRule, settings.spawnTarget(), settings.seaLevel(), settings.disableMobGeneration(), settings.aquifersEnabled(), settings.oreVeinsEnabled(), settings.useLegacyRandomSource());
    }
}

