/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.moddingx.libx.render.block.TransformingBlockRenderer;

public abstract class DirectionalBlockRenderer<T extends BlockEntity>
extends TransformingBlockRenderer<T> {
    @Override
    protected final void transform(@Nonnull T blockEntity, float partialTicks, @Nonnull PoseStack poseStack) {
        Direction facing = (Direction)blockEntity.getBlockState().getValue((Property)BlockStateProperties.FACING);
        float xRot = switch (facing) {
            case Direction.UP -> 0.0f;
            case Direction.DOWN -> 180.0f;
            default -> 90.0f;
        };
        float yRot = facing.getAxis() == Direction.Axis.Y ? 0.0f : facing.toYRot();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(Axis.XP.rotationDegrees(xRot));
        poseStack.mulPose(Axis.ZP.rotationDegrees(yRot));
        poseStack.translate(-0.5, -0.5, -0.5);
    }
}

