/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.moddingx.libx.impl.render.BlockOverlayQuadCache;

public class RenderHelperBlock {
    private static final RenderType RENDER_TYPE_BREAK = RenderType.crumbling((ResourceLocation)InventoryMenu.BLOCK_ATLAS);
    private static final RandomSource random = RandomSource.create();

    public static void renderBlockBreak(BlockState state, PoseStack poseStack, int light, int overlay, int breakProgress) {
        RenderHelperBlock.renderBlockBreak(state, poseStack, light, overlay, breakProgress, state.getSeed(BlockPos.ZERO));
    }

    public static void renderBlockBreak(BlockState state, PoseStack poseStack, int light, int overlay, int breakProgress, long positionRandom) {
        if (breakProgress > 0) {
            ResourceLocation tex = (ResourceLocation)ModelBakery.DESTROY_STAGES.get((breakProgress - 1) % ModelBakery.DESTROY_STAGES.size());
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(tex);
            RenderHelperBlock.renderBlockOverlaySprite(state, poseStack, light, overlay, sprite, positionRandom);
        }
    }

    public static void renderBlockOverlaySprite(BlockState state, PoseStack poseStack, int light, int overlay, TextureAtlasSprite sprite) {
        RenderHelperBlock.renderBlockOverlaySprite(state, poseStack, light, overlay, sprite, state.getSeed(BlockPos.ZERO));
    }

    public static void renderBlockOverlaySprite(BlockState state, PoseStack poseStack, int light, int overlay, TextureAtlasSprite sprite, long positionRandom) {
        RenderHelperBlock.renderBlockOverlaySprite(state, poseStack, light, overlay, sprite, positionRandom, dir -> true);
    }

    public static void renderBlockOverlaySprite(BlockState state, PoseStack poseStack, int light, int overlay, TextureAtlasSprite sprite, Predicate<Direction> dirs) {
        RenderHelperBlock.renderBlockOverlaySprite(state, poseStack, light, overlay, sprite, state.getSeed(BlockPos.ZERO), dirs);
    }

    public static void renderBlockOverlaySprite(BlockState state, PoseStack poseStack, int light, int overlay, TextureAtlasSprite sprite, long positionRandom, Predicate<Direction> dirs) {
        if (state.getRenderShape() == RenderShape.MODEL) {
            BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getBlockModel(state);
            VertexConsumer vertex = Minecraft.getInstance().renderBuffers().crumblingBufferSource().getBuffer(RENDER_TYPE_BREAK);
            for (Direction direction : Direction.values()) {
                random.setSeed(positionRandom);
                List list = model.getQuads(state, direction, random, ModelData.EMPTY, RENDER_TYPE_BREAK);
                if (list.isEmpty()) continue;
                RenderHelperBlock.renderBlockOverlayQuad(DefaultVertexFormat.BLOCK, poseStack.last(), vertex, list, light, overlay, sprite, dirs);
            }
            random.setSeed(positionRandom);
            List list = model.getQuads(state, null, random, ModelData.EMPTY, RENDER_TYPE_BREAK);
            if (!list.isEmpty()) {
                RenderHelperBlock.renderBlockOverlayQuad(DefaultVertexFormat.BLOCK, poseStack.last(), vertex, list, light, overlay, sprite, dirs);
            }
        }
    }

    public static void endOverlayBatch() {
        Minecraft.getInstance().renderBuffers().crumblingBufferSource().endBatch(RENDER_TYPE_BREAK);
    }

    private static void renderBlockOverlayQuad(VertexFormat format, PoseStack.Pose pose, VertexConsumer vertex, List<BakedQuad> list, int light, int overlay, TextureAtlasSprite sprite, Predicate<Direction> dirs) {
        for (BakedQuad quad : list) {
            if (!dirs.test(quad.getDirection())) continue;
            vertex.putBulkData(pose, RenderHelperBlock.modifyBlockQuad(format, quad, sprite), 1.0f, 1.0f, 1.0f, 1.0f, light, overlay);
        }
    }

    private static BakedQuad modifyBlockQuad(VertexFormat format, BakedQuad quad, TextureAtlasSprite newSprite) {
        BakedQuad result = BlockOverlayQuadCache.get(quad, newSprite);
        if (result == null) {
            int[] data = quad.getVertices();
            int[] newData = new int[data.length];
            System.arraycopy(data, 0, newData, 0, data.length);
            int uvByteOff = format.getOffset(VertexFormatElement.UV);
            if (uvByteOff != -1 && uvByteOff % 4 == 0) {
                int uvOff = uvByteOff / 4;
                TextureAtlasSprite oldSprite = quad.getSprite();
                int intSize = format.getVertexSize() / 4;
                int off = 0;
                while (off + uvOff + 1 < newData.length) {
                    newData[off + uvOff] = Float.floatToRawIntBits((Float.intBitsToFloat(data[off + uvOff]) - oldSprite.getU0()) * (float)newSprite.contents().width() / (float)oldSprite.contents().width() + newSprite.getU0());
                    newData[off + uvOff + 1] = Float.floatToRawIntBits((Float.intBitsToFloat(data[off + uvOff + 1]) - oldSprite.getV0()) * (float)newSprite.contents().height() / (float)oldSprite.contents().height() + newSprite.getV0());
                    off += intSize;
                }
            }
            result = new BakedQuad(newData, quad.getTintIndex(), quad.getDirection(), newSprite, quad.isShade());
            BlockOverlayQuadCache.put(quad, result);
        }
        return result;
    }
}

