/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.registration.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import org.moddingx.libx.annotation.registration.PlainRegisterable;
import org.moddingx.libx.registration.Registerable;
import org.moddingx.libx.registration.RegistrationContext;

@PlainRegisterable
public final class EnumObjects<E extends Enum<E>, T>
implements Registerable {
    private final ResourceKey<? extends Registry<T>> registryKey;
    private final T defaultValue;
    private final E[] keys;
    private final Map<E, T> map;

    public EnumObjects(ResourceKey<? extends Registry<T>> registryKey, Class<E> cls, Function<E, T> factory) {
        this.registryKey = registryKey;
        if (!cls.isEnum()) {
            throw new IllegalStateException("Non-enum class in EnumObjects: " + cls.getName());
        }
        Object defaultValue = null;
        this.map = new HashMap<E, T>();
        this.keys = (Enum[])cls.getEnumConstants();
        if (this.keys.length == 0) {
            throw new IllegalStateException("EnumObjects cannot be used with empty enums.");
        }
        for (E e : this.keys) {
            T t = factory.apply(e);
            if (defaultValue == null) {
                defaultValue = t;
            }
            this.map.put(e, t);
        }
        this.defaultValue = Objects.requireNonNull(defaultValue, "EnumObjects cannot be used with empty enums.");
    }

    public T get(E key) {
        return this.map.getOrDefault(key, this.defaultValue);
    }

    public T random(RandomSource random) {
        return this.map.get(this.keys[random.nextInt(this.keys.length)]);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void registerAdditional(RegistrationContext ctx, Registerable.EntryCollector builder) {
        for (Map.Entry<E, T> entry : this.map.entrySet()) {
            builder.registerNamed(this.registryKey, ((Enum)entry.getKey()).name().toLowerCase(Locale.ROOT), entry.getValue());
        }
    }
}

