/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.registration;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.moddingx.libx.mod.ModXRegistration;
import org.moddingx.libx.registration.SetupContext;

public sealed class RegistrationContext
permits SetupContext {
    private final ModXRegistration mod;
    private final ResourceLocation id;
    private final Optional<ResourceKey<?>> key;
    private final Optional<ResourceKey<? extends Registry<?>>> registry;

    public RegistrationContext(ModXRegistration mod, ResourceLocation id, @Nullable ResourceKey<?> key) {
        this.mod = mod;
        this.id = id;
        this.key = Optional.ofNullable(key);
        this.registry = this.key.map(ResourceKey::registry).map(ResourceKey::createRegistryKey);
        if (this.key.isPresent() && !Objects.equals(this.id, this.key.get().location())) {
            throw new IllegalArgumentException("Id does not match resource key: " + String.valueOf(id) + " " + String.valueOf(key));
        }
    }

    public ModXRegistration mod() {
        return this.mod;
    }

    public ResourceLocation id() {
        return this.id;
    }

    public Optional<ResourceKey<?>> key() {
        return this.key;
    }

    public Optional<ResourceKey<? extends Registry<?>>> registry() {
        return this.registry;
    }
}

