/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.menu;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.moddingx.libx.menu.MenuBase;

public abstract class DefaultMenu
extends MenuBase {
    protected final Player player;
    protected final Level level;
    public final int firstOutputSlot;
    public final int firstInventorySlot;

    protected DefaultMenu(@Nullable MenuType<?> type, int windowId, Level level, Player player, Inventory inventory, int firstOutputSlot, int firstInventorySlot) {
        super(type, windowId, inventory);
        this.player = player;
        this.level = level;
        this.firstOutputSlot = firstOutputSlot;
        this.firstInventorySlot = firstInventorySlot;
    }

    public Level getLevel() {
        return this.level;
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack stack = slot.getItem();
            itemstack = stack.copy();
            int inventorySize = this.firstInventorySlot;
            int playerInventoryEnd = inventorySize + 27;
            int playerHotBarEnd = playerInventoryEnd + 9;
            if (index < this.firstOutputSlot) {
                if (!this.moveItemStackTo(stack, inventorySize, playerHotBarEnd, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(stack, itemstack);
            } else if (index >= inventorySize) {
                if (!this.moveItemStackTo(stack, 0, this.firstOutputSlot, false)) {
                    return ItemStack.EMPTY;
                }
                if (index < playerInventoryEnd ? !this.moveItemStackTo(stack, playerInventoryEnd, playerHotBarEnd, false) : index < playerHotBarEnd && !this.moveItemStackTo(stack, inventorySize, playerInventoryEnd, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (!this.moveItemStackTo(stack, inventorySize, playerHotBarEnd, false)) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stack);
        }
        return itemstack;
    }
}

