/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.sandbox.layer;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class NoiseLayerSelector {
    private final DensityFunction[] densities;

    public NoiseLayerSelector(List<DensityFunction> densities, RandomSource random) {
        if (densities.isEmpty()) {
            throw new IllegalArgumentException("No elements");
        }
        this.densities = new DensityFunction[densities.size()];
        for (int i = 0; i < this.densities.length; ++i) {
            this.densities[i] = this.createDensity(densities.get(i), random);
        }
    }

    public int sample(int x, int y, int z, boolean[] allow) {
        DensityFunction.SinglePointContext context = new DensityFunction.SinglePointContext(x, y, z);
        double max = Double.NEGATIVE_INFINITY;
        int maxIdx = 0;
        for (int i = 0; i < this.densities.length; ++i) {
            double v;
            if (!allow[i] || !((v = this.densities[i].compute((DensityFunction.FunctionContext)context)) > max)) continue;
            max = v;
            maxIdx = i;
        }
        return maxIdx;
    }

    private DensityFunction createDensity(DensityFunction density, RandomSource random) {
        final long seed = random.nextLong() ^ 0x1E6AC71A7E85E1ECL;
        final HashMap wrappedDensities = new HashMap();
        return density.mapAll(new DensityFunction.Visitor(){

            @Nonnull
            public DensityFunction apply(@Nonnull DensityFunction density) {
                return wrappedDensities.computeIfAbsent(density, k -> {
                    if (density instanceof DensityFunctions.HolderHolder) {
                        DensityFunctions.HolderHolder holder = (DensityFunctions.HolderHolder)density;
                        return (DensityFunction)holder.function().value();
                    }
                    if (density instanceof DensityFunctions.MarkerOrMarked) {
                        DensityFunctions.MarkerOrMarked marker = (DensityFunctions.MarkerOrMarked)density;
                        return marker.wrapped();
                    }
                    return density;
                });
            }

            @Nonnull
            public DensityFunction.NoiseHolder visitNoise(@Nonnull DensityFunction.NoiseHolder noise) {
                long xor = noise.noiseData().unwrapKey().map(key -> (long)key.location().getNamespace().hashCode() << 32 | (long)key.location().getPath().hashCode()).orElse(42L);
                return new DensityFunction.NoiseHolder(noise.noiseData(), NormalNoise.create((RandomSource)RandomSource.create((long)(seed ^ xor)), (NormalNoise.NoiseParameters)((NormalNoise.NoiseParameters)noise.noiseData().value())));
            }
        });
    }
}

