/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.sandbox.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record DensityInfluence(DensityFunction base, DensityFunction modifier, DensityFunction influence, double minInfluence, double maxInfluence) implements DensityFunction
{
    public static final KeyDispatchDataCodec<DensityInfluence> CODEC = KeyDispatchDataCodec.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("base").forGetter(DensityInfluence::base), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("modifier").forGetter(DensityInfluence::modifier), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("influence").forGetter(DensityInfluence::influence), (App)Codec.DOUBLE.optionalFieldOf("min_influence", (Object)-1.0).forGetter(DensityInfluence::minInfluence), (App)Codec.DOUBLE.optionalFieldOf("max_influence", (Object)-1.0).forGetter(DensityInfluence::maxInfluence)).apply((Applicative)instance, DensityInfluence::new)));

    @Nonnull
    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC;
    }

    public double compute(@Nonnull DensityFunction.FunctionContext context) {
        double influence = this.minInfluence() + this.influence().compute(context) / (this.maxInfluence() - this.minInfluence());
        return this.base().compute(context) + influence * this.modifier().compute(context);
    }

    public void fillArray(@Nonnull double[] array, @Nonnull DensityFunction.ContextProvider provider) {
        double[] influence = new double[array.length];
        double[] modifier = new double[array.length];
        this.base().fillArray(array, provider);
        this.influence().fillArray(influence, provider);
        this.modifier().fillArray(modifier, provider);
        for (int i = 0; i < array.length; ++i) {
            int n = i;
            array[n] = array[n] + (this.minInfluence() + influence[i] / (this.maxInfluence() - this.minInfluence())) * modifier[i];
        }
    }

    @Nonnull
    public DensityFunction mapAll(@Nonnull DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new DensityInfluence(this.base().mapAll(visitor), this.modifier().mapAll(visitor), this.influence().mapAll(visitor), this.minInfluence(), this.maxInfluence()));
    }

    public double minValue() {
        return this.base().minValue() + (this.minInfluence() + this.influence().minValue() / (this.maxInfluence() - this.minInfluence())) * this.modifier().minValue();
    }

    public double maxValue() {
        return this.base().maxValue() + (this.minInfluence() + this.influence().maxValue() / (this.maxInfluence() - this.minInfluence())) * this.modifier().maxValue();
    }
}

