/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.loot.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.LootModifier;

public class AdditionLootModifier
extends LootModifier {
    public static final MapCodec<AdditionLootModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("loot_table").forGetter(lm -> lm.table.location()), (App)ResourceLocation.CODEC.optionalFieldOf("random_sequence").forGetter(lm -> lm.randomSequence), (App)LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(lm -> lm.conditions)).apply((Applicative)instance, AdditionLootModifier::new));
    private final ResourceKey<LootTable> table;
    private final Optional<ResourceLocation> randomSequence;

    public AdditionLootModifier(ResourceLocation table, LootItemCondition ... conditions) {
        this(table, Optional.empty(), conditions);
    }

    public AdditionLootModifier(ResourceLocation table, ResourceLocation randomSequence, LootItemCondition ... conditions) {
        this(table, Optional.of(randomSequence), conditions);
    }

    private AdditionLootModifier(ResourceLocation table, Optional<ResourceLocation> randomSequence, LootItemCondition ... conditions) {
        super(conditions);
        this.table = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)table);
        this.randomSequence = randomSequence;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(@Nonnull ObjectArrayList<ItemStack> loot, @Nonnull LootContext context) {
        Holder.Reference table = context.getResolver().get(Registries.LOOT_TABLE, this.table).orElse(null);
        if (table != null) {
            LootContext copy = new LootContext.Builder(context).withQueriedLootTableId(this.table.location()).create(this.randomSequence);
            ObjectArrayList stacks = ((LootTable)table.value()).getRandomItems(copy);
            loot.addAll((ObjectList)stacks);
        }
        return loot;
    }

    @Nonnull
    public MapCodec<? extends AdditionLootModifier> codec() {
        return CODEC;
    }
}

