/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.moddingx.libx.LibX;

public class CopyBlockEntityDataFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation ID = LibX.getInstance().resource("copy_block_entity_data");
    public static final MapCodec<CopyBlockEntityDataFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> CopyBlockEntityDataFunction.commonFields((RecordCodecBuilder.Instance)instance).and(instance.group((App)BuiltInRegistries.BLOCK.holderByNameCodec().fieldOf("block").forGetter(function -> function.block), (App)Codec.STRING.listOf().fieldOf("tags").forGetter(function -> function.tags.stream().sorted().toList()))).apply((Applicative)instance, CopyBlockEntityDataFunction::new));
    public static final LootItemFunctionType<CopyBlockEntityDataFunction> TYPE = new LootItemFunctionType(CODEC);
    private final Holder<Block> block;
    private final Set<String> tags;

    private CopyBlockEntityDataFunction(List<LootItemCondition> conditions, Holder<Block> block, List<String> tags) {
        this(conditions, block, Set.copyOf(tags));
    }

    public CopyBlockEntityDataFunction(List<LootItemCondition> conditions, Holder<Block> block, Set<String> tags) {
        super(conditions);
        this.block = block;
        this.tags = Set.copyOf(tags);
    }

    @Nonnull
    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return TYPE;
    }

    @Nonnull
    protected ItemStack run(@Nonnull ItemStack stack, @Nonnull LootContext context) {
        BlockEntity blockEntity = (BlockEntity)context.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (blockEntity != null) {
            stack.update(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY, data -> {
                CompoundTag blockEntityData = blockEntity.saveCustomOnly((HolderLookup.Provider)context.getLevel().registryAccess());
                for (String tagName : this.tags) {
                    Tag tag;
                    if (!blockEntityData.contains(tagName) || (tag = blockEntityData.get(tagName)) == null) continue;
                    data = data.update(nbt -> nbt.put(tagName, tag.copy()));
                }
                data = data.update(nbt -> nbt.putString("id", Objects.requireNonNull(BlockEntityType.getKey((BlockEntityType)blockEntity.getType())).toString()));
                return data;
            });
        }
        return stack;
    }

    public static Builder copyBlockEntityData(Block block, Set<String> tags) {
        return new Builder(block, tags);
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final Holder<Block> block;
        private final Set<String> tags;

        private Builder(Block block, Set<String> tags) {
            this.block = block.builtInRegistryHolder();
            this.tags = Set.copyOf(tags);
        }

        @Nonnull
        protected Builder getThis() {
            return this;
        }

        @Nonnull
        public CopyBlockEntityDataFunction build() {
            return new CopyBlockEntityDataFunction((List<LootItemCondition>)this.getConditions(), this.block, this.tags);
        }
    }
}

