/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.loot;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.ComposableEntryContainer;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.moddingx.libx.LibX;

public class AllLootEntry
extends CompositeEntryBase {
    public static final ResourceLocation ID = LibX.getInstance().resource("all");
    public static final MapCodec<AllLootEntry> CODEC = AllLootEntry.createCodec(AllLootEntry::new);
    public static final LootPoolEntryType TYPE = new LootPoolEntryType(CODEC);

    public AllLootEntry(List<LootPoolEntryContainer> children, List<LootItemCondition> conditions) {
        super(children, conditions);
    }

    @Nonnull
    public LootPoolEntryType getType() {
        return TYPE;
    }

    @Nonnull
    protected ComposableEntryContainer compose(@Nonnull List<? extends ComposableEntryContainer> children) {
        return switch (children.size()) {
            case 0 -> ALWAYS_TRUE;
            case 1 -> children.getFirst();
            default -> (ctx, consumer) -> {
                final ArrayList list = new ArrayList();
                boolean success = false;
                for (ComposableEntryContainer entry : children) {
                    if (!entry.expand(ctx, list::add)) continue;
                    success = true;
                }
                if (list.size() == 1) {
                    consumer.accept((LootPoolEntry)list.get(0));
                } else if (!list.isEmpty()) {
                    consumer.accept(new LootPoolEntry(){

                        public int getWeight(float luck) {
                            int total = 0;
                            for (LootPoolEntry gen : list) {
                                total += gen.getWeight(luck);
                            }
                            return total;
                        }

                        public void createItemStack(@Nonnull Consumer<ItemStack> stackConsumer, @Nonnull LootContext lootContext) {
                            for (LootPoolEntry gen : list) {
                                gen.createItemStack(stackConsumer, lootContext);
                            }
                        }
                    });
                }
                return success;
            };
        };
    }
}

