/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.datapack;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.RepositorySource;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import org.moddingx.libx.LibX;
import org.moddingx.libx.impl.datapack.LibXPack;
import org.moddingx.libx.util.lazy.LazyValue;

public class DynamicPackLocator
implements RepositorySource {
    public static final DynamicPackLocator RESOURCE_PACKS = new DynamicPackLocator(PackType.CLIENT_RESOURCES);
    public static final DynamicPackLocator DATA_PACKS = new DynamicPackLocator(PackType.SERVER_DATA);
    private final PackType type;
    private final Set<ResourceLocation> enabledPacks = new HashSet<ResourceLocation>();

    private DynamicPackLocator(PackType type) {
        this.type = type;
    }

    public static void locatePacks(AddPackFindersEvent event) {
        if (PackType.CLIENT_RESOURCES.equals((Object)event.getPackType())) {
            event.addRepositorySource((RepositorySource)RESOURCE_PACKS);
        }
        if (PackType.SERVER_DATA.equals((Object)event.getPackType())) {
            event.addRepositorySource((RepositorySource)DATA_PACKS);
        }
    }

    public synchronized void enablePack(ResourceLocation id) {
        if (!Objects.equals(id.getNamespace(), ModLoadingContext.get().getActiveNamespace())) {
            LibX.logger.error("Wrong modid for dynamic pack, expected " + ModLoadingContext.get().getActiveNamespace() + " got " + id.getNamespace());
        }
        this.enabledPacks.add(id);
    }

    public synchronized boolean isEnabled(ResourceLocation id) {
        return this.enabledPacks.contains(id);
    }

    public void loadPacks(@Nonnull Consumer<Pack> packs) {
        for (ResourceLocation id : this.enabledPacks) {
            LazyValue<LibXPack> resources;
            IModFileInfo modFileInfo;
            IModInfo modInfo = ModList.get().getModContainerById(id.getNamespace()).map(ModContainer::getModInfo).orElse(null);
            IModFileInfo iModFileInfo = modFileInfo = modInfo == null ? null : modInfo.getOwningFile();
            if (modInfo == null || modFileInfo == null || modFileInfo.getFile() == null) {
                LibX.logger.error("Can't create dynamic pack " + String.valueOf(id) + ": Invalid mod file: " + id.getNamespace() + " (" + String.valueOf(modFileInfo) + ")");
                continue;
            }
            PackLocationInfo location = LibXPack.generateLocationInfo(modInfo, this.type, id.getPath());
            Pack pack = Pack.readMetaAndCreate((PackLocationInfo)location, (Pack.ResourcesSupplier)new SimpleResourceSupplier(resources = new LazyValue<LibXPack>(() -> new LibXPack(location, this.type, modInfo, modFileInfo.getFile(), id.getPath()))), (PackType)this.type, (PackSelectionConfig)LibXPack.PACK_CONFIG.get(this.type).selection());
            if (pack == null) continue;
            packs.accept(pack);
        }
    }

    private record SimpleResourceSupplier(LazyValue<? extends PackResources> resources) implements Pack.ResourcesSupplier
    {
        @Nonnull
        public PackResources openPrimary(@Nonnull PackLocationInfo location) {
            return this.resources().get();
        }

        @Nonnull
        public PackResources openFull(@Nonnull PackLocationInfo location, @Nonnull Pack.Metadata metadata) {
            return this.resources().get();
        }
    }
}

