/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.datagen.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import org.moddingx.libx.datagen.provider.recipe.RecipeExtension;

public class ObjectCraftingBuilder {
    public static void buildShaped(RecipeExtension ext, Object[] objects) {
        ObjectReader reader = new ObjectReader(objects);
        ResourceLocation id = ObjectCraftingBuilder.getId(reader);
        RecipeCategory recipeCategory = ObjectCraftingBuilder.getRecipeCategory(reader);
        List<ICondition> conditions = ObjectCraftingBuilder.getConditions(reader);
        ItemStack output = ObjectCraftingBuilder.getOutput(reader);
        if (id == null) {
            id = ext.provider().loc((ItemLike)output.getItem());
        }
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)recipeCategory, (ItemStack)output);
        for (String line : reader.consumeWhile(String.class)) {
            builder.pattern(line);
        }
        ObjectCraftingBuilder.addShapedIngredients(ext, builder, reader);
        RecipeOutput recipeOutput = ext.output();
        if (!conditions.isEmpty()) {
            recipeOutput = recipeOutput.withConditions((ICondition[])conditions.toArray(ICondition[]::new));
        }
        builder.save(recipeOutput, id);
    }

    public static void buildShapeless(RecipeExtension ext, Object[] objects) {
        ObjectReader reader = new ObjectReader(objects);
        ResourceLocation id = ObjectCraftingBuilder.getId(reader);
        RecipeCategory recipeCategory = ObjectCraftingBuilder.getRecipeCategory(reader);
        List<ICondition> conditions = ObjectCraftingBuilder.getConditions(reader);
        ItemStack output = ObjectCraftingBuilder.getOutput(reader);
        if (id == null) {
            id = ext.provider().loc((ItemLike)output.getItem());
        }
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.shapeless((RecipeCategory)recipeCategory, (ItemStack)output);
        ObjectCraftingBuilder.addShapelessIngredients(ext, builder, reader);
        RecipeOutput recipeOutput = ext.output();
        if (!conditions.isEmpty()) {
            recipeOutput = recipeOutput.withConditions((ICondition[])conditions.toArray(ICondition[]::new));
        }
        builder.save(recipeOutput, id);
    }

    @Nullable
    private static ResourceLocation getId(ObjectReader reader) {
        return reader.optConsume(ResourceLocation.class).orElse(null);
    }

    @Nonnull
    private static RecipeCategory getRecipeCategory(ObjectReader reader) {
        return reader.optConsume(RecipeCategory.class).orElse(RecipeCategory.MISC);
    }

    @Nonnull
    private static List<ICondition> getConditions(ObjectReader reader) {
        return ObjectCraftingBuilder.first(() -> reader.optConsume(ICondition.class).map(List::of), () -> reader.optConsume(ICondition[].class).map(List::of)).orElse(List.of());
    }

    private static void addShapedIngredients(RecipeExtension ext, ShapedRecipeBuilder builder, ObjectReader reader) {
        Optional<Character> value;
        int nextId = 0;
        while ((value = reader.expectConsume(Character.class)).isPresent()) {
            char key = value.get().charValue();
            Ingredient ingredient = ObjectCraftingBuilder.getIngredient(reader);
            builder.define(Character.valueOf(key), ingredient);
            nextId = ObjectCraftingBuilder.addCriteriaToBuilder((arg_0, arg_1) -> ((ShapedRecipeBuilder)builder).unlockedBy(arg_0, arg_1), ext.criteria(ingredient), nextId);
        }
    }

    private static void addShapelessIngredients(RecipeExtension ext, ShapelessRecipeBuilder builder, ObjectReader reader) {
        int nextId = 0;
        while (reader.hasNext()) {
            Ingredient ingredient = ObjectCraftingBuilder.getIngredient(reader);
            builder.requires(ingredient);
            nextId = ObjectCraftingBuilder.addCriteriaToBuilder((arg_0, arg_1) -> ((ShapelessRecipeBuilder)builder).unlockedBy(arg_0, arg_1), ext.criteria(ingredient), nextId);
        }
    }

    private static int addCriteriaToBuilder(BiConsumer<String, Criterion<?>> triggers, List<Criterion<?>> criteria, int nextId) {
        for (Criterion<?> criterion : criteria) {
            triggers.accept("criterion" + nextId++, criterion);
        }
        return nextId;
    }

    @Nonnull
    private static Ingredient getIngredient(ObjectReader reader) {
        return (Ingredient)ObjectCraftingBuilder.first(() -> reader.optConsume(ItemLike.class).map(xva$0 -> Ingredient.of((ItemLike[])new ItemLike[]{xva$0})), () -> reader.optConsume(TagKey.class).map(ObjectCraftingBuilder::createTagIngredient), () -> reader.optConsume(Ingredient.class), () -> reader.optConsume(List.class).map(list -> {
            ObjectReader sub = new ObjectReader(list.toArray());
            ArrayList<Ingredient> subList = new ArrayList<Ingredient>();
            while (sub.hasNext()) {
                subList.add(ObjectCraftingBuilder.getIngredient(sub));
            }
            return CompoundIngredient.of((Ingredient[])subList.toArray(new Ingredient[0]));
        })).orElseThrow(() -> new IllegalStateException("Can't build recipe, invalid ingredient at position " + reader.pos()));
    }

    @Nonnull
    private static ItemStack getOutput(ObjectReader reader) {
        return (ItemStack)ObjectCraftingBuilder.first(() -> reader.optConsume(ItemLike.class).map(item -> new ItemStack(item, reader.optConsume(Integer.class).orElse(1).intValue())), () -> reader.optConsume(ItemStack.class).map(ItemStack::copy)).orElseThrow(() -> new IllegalStateException("Can't build recipe, invalid output at position " + reader.pos()));
    }

    private static Ingredient createTagIngredient(TagKey<?> key) {
        if (key.registry() != Registries.ITEM) {
            throw new IllegalArgumentException("Non-item tag in recipe: " + String.valueOf(key));
        }
        return Ingredient.of(key);
    }

    @SafeVarargs
    private static <T> Optional<T> first(Supplier<Optional<T>> ... values) {
        for (Supplier<Optional<Optional<T>>> supplier : values) {
            Optional<T> opt = supplier.get();
            if (!opt.isPresent()) continue;
            return opt;
        }
        return Optional.empty();
    }

    private static class ObjectReader {
        private final Object[] objects;
        private int idx;

        public ObjectReader(Object[] objects) {
            this.objects = objects;
            for (Object object : objects) {
                if (object != null) continue;
                throw new IllegalStateException("Can't build recipe, null objects are not allowed.");
            }
        }

        @Nonnull
        public Object peek() {
            if (this.idx >= this.objects.length) {
                throw new IllegalStateException("Can't build recipe, end of array.");
            }
            return this.objects[this.idx];
        }

        @Nonnull
        public <T> T peek(Class<T> cls) {
            if (this.idx >= this.objects.length) {
                throw new IllegalStateException("Can't build recipe, end of array, expected element of type " + String.valueOf(cls));
            }
            if (!cls.isAssignableFrom(this.objects[this.idx].getClass())) {
                throw new IllegalStateException("Can't build recipe, expected element of type " + String.valueOf(cls) + " at position " + this.idx);
            }
            return (T)this.objects[this.idx];
        }

        @Nonnull
        public <T> Optional<T> expect(Class<T> cls) {
            if (this.idx >= this.objects.length) {
                return Optional.empty();
            }
            if (!cls.isAssignableFrom(this.objects[this.idx].getClass())) {
                throw new IllegalStateException("Can't build recipe, expected element of type " + String.valueOf(cls) + " at position " + this.idx);
            }
            return Optional.of(this.objects[this.idx]);
        }

        @Nonnull
        public <T> Optional<T> expectConsume(Class<T> cls) {
            Optional<T> value = this.expect(cls);
            if (value.isPresent()) {
                this.consume();
            }
            return value;
        }

        @Nonnull
        public <T> Optional<T> opt(Class<T> cls) {
            if (this.idx >= this.objects.length) {
                return Optional.empty();
            }
            if (!cls.isAssignableFrom(this.objects[this.idx].getClass())) {
                return Optional.empty();
            }
            return Optional.of(this.objects[this.idx]);
        }

        @Nonnull
        public <T> Optional<T> optConsume(Class<T> cls) {
            Optional<T> value = this.opt(cls);
            if (value.isPresent()) {
                this.consume();
            }
            return value;
        }

        @Nonnull
        public <T> List<T> consumeWhile(Class<T> cls) {
            Optional<T> value;
            ArrayList<T> list = new ArrayList<T>();
            while ((value = this.optConsume(cls)).isPresent()) {
                list.add(value.get());
            }
            return list;
        }

        @Nonnull
        public Object consume() {
            if (this.idx >= this.objects.length) {
                throw new IllegalStateException("Can't build recipe, end of array.");
            }
            ++this.idx;
            return this.objects[this.idx - 1];
        }

        public boolean hasNext() {
            return this.idx < this.objects.length;
        }

        public int pos() {
            return this.idx;
        }
    }
}

