/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.datagen.loot;

import java.util.List;
import java.util.function.Function;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class LootData {
    public static LootPoolSingletonContainer.Builder<?> stack(ItemStack stack) {
        DataComponentPatch components;
        LootPoolSingletonContainer.Builder entry = LootItem.lootTableItem((ItemLike)stack.getItem());
        if (stack.getCount() != 1) {
            entry.apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)stack.getCount())));
        }
        if (stack.getDamageValue() != 0) {
            float damage = (float)(stack.getMaxDamage() - stack.getDamageValue()) / (float)stack.getMaxDamage();
            entry.apply((LootItemFunction.Builder)SetItemDamageFunction.setDamage((NumberProvider)ConstantValue.exactly((float)damage)));
        }
        if (!(components = stack.getComponentsPatch()).isEmpty()) {
            entry.apply((LootItemFunction.Builder)LootItemConditionalFunction.simpleBuilder(conditions -> new SetComponentsFunction(conditions, components)));
        }
        return entry;
    }

    public static <T> LootPoolEntryContainer.Builder<?> combineBy(Function<List<LootPoolEntryContainer.Builder<?>>, LootPoolEntryContainer.Builder<?>> combineFunc, Function<T, LootPoolEntryContainer.Builder<?>> extract, List<T> loot) {
        return LootData.combineBy(combineFunc, loot.stream().map(extract).toList());
    }

    public static LootPoolEntryContainer.Builder<?> combineBy(Function<List<LootPoolEntryContainer.Builder<?>>, LootPoolEntryContainer.Builder<?>> combineFunc, List<LootPoolEntryContainer.Builder<?>> loot) {
        if (loot.isEmpty()) {
            return EmptyLootItem.emptyItem();
        }
        if (loot.size() == 1) {
            return loot.get(0);
        }
        return combineFunc.apply(loot);
    }
}

