/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.datagen.load;

import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;
import org.moddingx.libx.LibX;
import org.moddingx.libx.impl.datagen.load.DatagenLoader;
import org.moddingx.libx.impl.libxcore.CoreRegistryLoad;

public class DatagenRegistryLoader {
    public static RegistryAccess.Frozen loadRegistries(ExistingFileHelper fileHelper, RegistrySelector selector) {
        LibX.logger.info("Start loading registries for datagen");
        ResourceManager mgr = DatagenLoader.resources(fileHelper, PackType.SERVER_DATA);
        LayeredRegistryAccess<RegistryLayer> access = RegistryLayer.createRegistryAccess();
        access = DatagenRegistryLoader.loadLayer(mgr, access, RegistryLayer.WORLDGEN, DatagenRegistryLoader.getDataPackRegistries(RegistryLayer.WORLDGEN, selector));
        CoreRegistryLoad.afterWorldGenLayerLoad(access);
        access = DatagenRegistryLoader.loadLayer(mgr, access, RegistryLayer.DIMENSIONS, DatagenRegistryLoader.getDataPackRegistries(RegistryLayer.DIMENSIONS, selector));
        LibX.logger.info("Finished loading registries for datagen");
        return access.compositeAccess();
    }

    private static LayeredRegistryAccess<RegistryLayer> loadLayer(ResourceManager mgr, LayeredRegistryAccess<RegistryLayer> access, RegistryLayer layer, List<RegistryDataLoader.RegistryData<?>> registries) {
        return access.replaceFrom((Object)layer, new RegistryAccess.Frozen[]{RegistryDataLoader.load((ResourceManager)mgr, (RegistryAccess)access.getAccessForLoading((Object)layer), registries)});
    }

    public static List<RegistryDataLoader.RegistryData<?>> getDataPackRegistries(@Nullable RegistryLayer layer, @Nullable RegistrySelector selector) {
        if (layer == null) {
            return Stream.concat(Stream.concat(DatagenRegistryLoader.getDataPackRegistries(RegistryLayer.STATIC, selector).stream(), DatagenRegistryLoader.getDataPackRegistries(RegistryLayer.WORLDGEN, selector).stream()), Stream.concat(DatagenRegistryLoader.getDataPackRegistries(RegistryLayer.DIMENSIONS, selector).stream(), DatagenRegistryLoader.getDataPackRegistries(RegistryLayer.RELOADABLE, selector).stream())).toList();
        }
        List<RegistryDataLoader.RegistryData<?>> defaultRegistries = switch (layer) {
            default -> throw new MatchException(null, null);
            case RegistryLayer.STATIC, RegistryLayer.RELOADABLE -> List.of();
            case RegistryLayer.WORLDGEN -> List.copyOf(DataPackRegistriesHooks.getDataPackRegistries());
            case RegistryLayer.DIMENSIONS -> List.copyOf(RegistryDataLoader.DIMENSION_REGISTRIES);
        };
        return selector == null ? defaultRegistries : List.copyOf(selector.selectRegistries(layer, defaultRegistries));
    }

    @FunctionalInterface
    public static interface RegistrySelector {
        public List<RegistryDataLoader.RegistryData<?>> selectRegistries(RegistryLayer var1, List<RegistryDataLoader.RegistryData<?>> var2);
    }
}

