/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.datagen.load;

import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.font.GlyphProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.font.FontManager;
import net.minecraft.client.gui.font.glyphs.SpecialGlyphs;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.moddingx.libx.LibX;
import org.moddingx.libx.impl.datagen.load.DatagenLoader;
import org.moddingx.libx.impl.reflect.ReflectionHacks;

public class DatagenFontLoader {
    public static final ResourceLocation ZERO_WIDTH_FONT = LibX.getInstance().resource("zero_width");
    public static final StringSplitter MISSING = new StringSplitter((cp, style) -> ZERO_WIDTH_FONT.equals((Object)style.getFont()) ? 0.0f : SpecialGlyphs.MISSING.getAdvance(style.isBold()));
    private static StringSplitter fontMetrics;

    public static StringSplitter getFontMetrics(@Nullable ExistingFileHelper fileHelper) {
        if (fontMetrics == null) {
            if (fileHelper == null) {
                throw new RuntimeException("Can't load font without file helper.");
            }
            try {
                LibX.logger.info("Loading font metrics during datagen.");
                ResourceManager rm = DatagenLoader.resources(fileHelper, PackType.CLIENT_RESOURCES);
                FontManager mgr = ReflectionHacks.newInstance(FontManager.class);
                FontManager.Preparation preparation = (FontManager.Preparation)mgr.prepare(rm, Runnable::run).get(0L, TimeUnit.NANOSECONDS);
                Map<ResourceLocation, List> providerMap = preparation.fontSets().entrySet().stream().map(entry -> {
                    ResourceLocation fontId = (ResourceLocation)entry.getKey();
                    ArrayList list = new ArrayList((Collection)entry.getValue());
                    Collections.reverse(list);
                    return Map.entry(fontId, Collections.unmodifiableList(list));
                }).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
                List defaultGlyphProviders = providerMap.getOrDefault(Style.DEFAULT_FONT, List.of());
                fontMetrics = new StringSplitter((cp, style) -> {
                    if (ZERO_WIDTH_FONT.equals((Object)style.getFont())) {
                        return 0.0f;
                    }
                    for (GlyphProvider.Conditional conditional : providerMap.getOrDefault(style.getFont(), defaultGlyphProviders)) {
                        GlyphInfo glyph;
                        if (!conditional.filter().apply(Set.of()) || (glyph = conditional.provider().getGlyph(cp)) == null) continue;
                        return glyph.getAdvance(style.isBold());
                    }
                    return SpecialGlyphs.MISSING.getAdvance(style.isBold());
                });
                LibX.logger.info("Font loading complete.");
            }
            catch (Exception e) {
                LibX.logger.error("Failed to load font metrics during datagen. Using Missing glyph provider.", (Throwable)e);
                fontMetrics = MISSING;
            }
        }
        return fontMetrics;
    }
}

