/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.config.wrapper;

import com.google.gson.JsonElement;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.moddingx.libx.config.mapper.ValueMapper;
import org.moddingx.libx.impl.config.wrapper.JsonTypesafeMapper;

public class TypesafeMapper
extends JsonTypesafeMapper<Object> {
    private TypesafeMapper(ValueMapper<?, ?> mapper) {
        super(mapper);
    }

    public static TypesafeMapper of(ValueMapper<?, ?> mapper) {
        if (mapper instanceof TypesafeMapper) {
            TypesafeMapper tm = (TypesafeMapper)mapper;
            return tm;
        }
        return new TypesafeMapper(mapper);
    }

    @Override
    public JsonElement toJson(Object value) {
        if (this.wrapped.type().isAssignableFrom(value.getClass())) {
            return this.wrapped.toJson(value);
        }
        throw new IllegalArgumentException("Type mismatch in config mapper toJson: Expected " + String.valueOf(this.wrapped.type()) + ", got " + String.valueOf(value.getClass()));
    }

    @Override
    public StreamCodec<? super FriendlyByteBuf, Object> streamCodec() {
        StreamCodec codec = this.wrapped.streamCodec();
        return StreamCodec.of((buf, value) -> {
            if (!this.wrapped.type().isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException("Type mismatch in config mapper write: Expected " + String.valueOf(this.wrapped.type()) + ", got " + String.valueOf(value.getClass()));
            }
            codec.encode(buf, value);
        }, arg_0 -> codec.decode(arg_0));
    }
}

