/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.config.gui.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import org.moddingx.libx.impl.config.ConfigImpl;
import org.moddingx.libx.impl.config.ConfigKey;
import org.moddingx.libx.impl.config.gui.screen.BuiltCategory;
import org.moddingx.libx.impl.config.gui.screen.BuiltEntry;
import org.moddingx.libx.impl.config.gui.screen.ConfigScreen;
import org.moddingx.libx.impl.config.gui.screen.ConfigScreenManager;

public class RootConfigScreen
extends ConfigScreen<ConfigKey> {
    public RootConfigScreen(ConfigScreenManager manager, ConfigImpl config) {
        super(manager, (Component)Component.translatable((String)"libx.config.gui.config.title", (Object[])new Object[]{config.id.getPath()}), RootConfigScreen.buildGrouped(config), RootConfigScreen::createEntry, RootConfigScreen::search);
    }

    private static Map<BuiltCategory, List<ConfigKey>> buildGrouped(ConfigImpl config) {
        HashMap<String, List> map = new HashMap<String, List>();
        HashMap<String, BuiltCategory> categories = new HashMap<String, BuiltCategory>();
        for (ConfigKey key : config.keys.values()) {
            if (key.path.size() == 1) {
                categories.putIfAbsent("", BuiltCategory.EMPTY);
                map.computeIfAbsent("", k -> new ArrayList()).add(key);
                continue;
            }
            String categoryId = String.join((CharSequence)".", key.path.subList(0, key.path.size() - 1));
            categories.computeIfAbsent(categoryId, k -> config.groups.stream().filter(group -> categoryId.equals(String.join((CharSequence)".", group.path))).findFirst().map(group -> new BuiltCategory(String.join((CharSequence)".", group.path), (Component)Component.literal((String)String.join((CharSequence)".", group.path)), (List)group.comment.stream().map(Component::literal).collect(ImmutableList.toImmutableList()))).orElseGet(() -> new BuiltCategory(String.join((CharSequence)".", key.path.subList(0, key.path.size() - 1)), (Component)Component.literal((String)String.join((CharSequence)".", key.path.subList(0, key.path.size() - 1))), List.of())));
            map.computeIfAbsent(categoryId, k -> new ArrayList()).add(key);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : map.entrySet()) {
            builder.put((Object)((BuiltCategory)categories.get(entry.getKey())), (Object)ImmutableList.copyOf((Collection)((Collection)entry.getValue())));
        }
        return builder.build();
    }

    private static BuiltEntry createEntry(ConfigKey key, ConfigScreen<ConfigKey> screen, @Nullable AbstractWidget old, int x, int y, int width, int height) {
        return new BuiltEntry((Component)Component.literal((String)key.path.getLast()), (ImmutableList<? extends Component>)((ImmutableList)key.comment.stream().map(Component::literal).collect(ImmutableList.toImmutableList())), screen.display.createWidget(key, screen, old, x, y, width, height));
    }

    private static boolean search(ConfigKey key, ConfigScreen<ConfigKey> screen, String query) {
        return query.isBlank() || String.join((CharSequence)".", key.path).toLowerCase(Locale.ROOT).contains(query.toLowerCase(Locale.ROOT)) || key.comment.stream().anyMatch(str -> str.toLowerCase(Locale.ROOT).contains(query));
    }
}

