/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.config.gui.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.tuple.Pair;
import org.moddingx.libx.impl.config.gui.ConfigDisplay;
import org.moddingx.libx.impl.config.gui.screen.BuiltCategory;
import org.moddingx.libx.impl.config.gui.screen.BuiltEntry;
import org.moddingx.libx.impl.config.gui.screen.ConfigBaseScreen;
import org.moddingx.libx.impl.config.gui.screen.ConfigScreenManager;
import org.moddingx.libx.impl.config.gui.screen.widget.TextWidget;

public abstract class ConfigScreen<T>
extends ConfigBaseScreen {
    public final ConfigDisplay display;
    public final ConfigScreenManager manager;
    protected final Map<BuiltCategory, List<T>> keys;
    protected final ElementFactory<T> factory;
    protected final SearchPredicate<T> searchPredicate;
    protected Map<T, BuiltEntry> elements = Map.of();

    public ConfigScreen(ConfigScreenManager manager, Component title, List<T> elements, ElementFactory<T> factory, SearchPredicate<T> searchPredicate) {
        this(manager, title, Map.of(BuiltCategory.EMPTY, elements), factory, searchPredicate);
    }

    public ConfigScreen(ConfigScreenManager manager, Component title, Map<BuiltCategory, List<T>> elements, ElementFactory<T> factory, SearchPredicate<T> searchPredicate) {
        super(title, manager, true);
        this.display = manager.display;
        this.manager = manager;
        this.keys = (Map)elements.entrySet().stream().map(e -> Pair.of((Object)((BuiltCategory)e.getKey()), (Object)ImmutableList.copyOf((Collection)((Collection)e.getValue())))).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
        this.factory = new ApplyTooltipFactory<T>(factory);
        this.searchPredicate = searchPredicate;
    }

    @Override
    protected void buildGui(Consumer<AbstractWidget> consumer) {
        int y = 5;
        int editorWidth = Math.min(200, (int)Math.round((double)this.contentWidth() * 0.4));
        int titleWidth = Math.max(0, this.contentWidth() - 15 - editorWidth - 25);
        HashMap<T, BuiltEntry> entryBuilder = new HashMap<T, BuiltEntry>(this.elements);
        String query = this.searchTerm();
        boolean first = true;
        for (BuiltCategory category : this.keys.keySet().stream().sorted(Comparator.comparing(BuiltCategory::id)).toList()) {
            if (!this.keys.get(category).stream().anyMatch(t -> this.searchPredicate.test(t, this, query))) continue;
            if (!category.id().isEmpty()) {
                if (!first) {
                    y += 10;
                }
                consumer.accept(new TextWidget(4, y, this.contentWidth(), 20, category.title(), category.description()));
                y += 23;
            }
            first = false;
            for (T t2 : this.keys.get(category)) {
                if (!this.searchPredicate.test(t2, this, query)) continue;
                BuiltEntry oldEntry = this.elements.getOrDefault(t2, null);
                BuiltEntry entry = this.factory.create(t2, this, oldEntry == null ? null : oldEntry.widget(), this.contentWidth() - 5 - editorWidth, y, editorWidth, 20);
                entryBuilder.put(t2, entry);
                consumer.accept(new TextWidget(15, entry.widget().getY(), titleWidth, entry.widget().getHeight(), entry.title(), (List<? extends Component>)entry.description()));
                consumer.accept(entry.widget());
                y += 23;
            }
        }
        this.elements = ImmutableMap.copyOf(entryBuilder);
    }

    @Override
    protected void searchChange(String term) {
        this.rebuild();
    }

    public static interface ElementFactory<T> {
        public BuiltEntry create(T var1, ConfigScreen<T> var2, @Nullable AbstractWidget var3, int var4, int var5, int var6, int var7);
    }

    public static interface SearchPredicate<T> {
        public boolean test(T var1, ConfigScreen<T> var2, String var3);
    }

    private record ApplyTooltipFactory<T>(ElementFactory<T> factory) implements ElementFactory<T>
    {
        @Override
        public BuiltEntry create(T elem, ConfigScreen<T> screen, @Nullable AbstractWidget oldWidget, int x, int y, int width, int height) {
            BuiltEntry entry = this.factory().create(elem, screen, oldWidget, x, y, width, height);
            if (entry.widget().getTooltip() == null) {
                entry.widget().setTooltip(Tooltip.create((Component)entry.title()));
            }
            return entry;
        }
    }
}

