/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.config.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.util.Either;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.widget.ScrollPanel;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.moddingx.libx.impl.config.gui.screen.ConfigScreenManager;
import org.moddingx.libx.render.FilterGuiGraphics;
import org.moddingx.libx.render.RenderHelper;

public abstract class ConfigBaseScreen
extends Screen {
    protected final Minecraft mc;
    @Nullable
    private final ConfigScreenManager manager;
    private final boolean hasSearchBar;
    @Nullable
    private EditBox searchBar;
    @Nullable
    private BasePanel panel;
    private final List<Pair<Matrix4f, Consumer<GuiGraphics>>> capturedTooltips = new LinkedList<Pair<Matrix4f, Consumer<GuiGraphics>>>();
    private boolean isCapturingTooltips = false;
    private int currentScrollOffset = 0;

    protected ConfigBaseScreen(Component title, @Nullable ConfigScreenManager manager, boolean hasSearchBar) {
        super(title);
        this.mc = Minecraft.getInstance();
        this.manager = manager;
        this.hasSearchBar = hasSearchBar;
    }

    public int contentWidth() {
        return this.width - 12;
    }

    protected void init() {
        if (this.manager != null) {
            Button back = Button.builder((Component)Component.literal((String)"\u2190 ").append((Component)Component.translatable((String)"libx.config.gui.back")), button -> this.manager.close()).pos(5, 5).size(52, 20).build();
            this.addRenderableWidget((GuiEventListener)back);
        }
        if (this.hasSearchBar) {
            boolean shouldFocus = this.searchBar != null && this.searchBar.isFocused();
            boolean isActive = this.searchBar != null && this.getFocused() == this.searchBar;
            Font font = this.mc.font;
            Objects.requireNonNull(this.mc.font);
            this.searchBar = new EditBox(font, 20, 18 + 9, this.width - 40, 20, this.searchBar, (Component)Component.translatable((String)"libx.config.gui.search.title"));
            this.searchBar.setMaxLength(Short.MAX_VALUE);
            this.searchBar.setFocused(shouldFocus);
            this.addRenderableWidget((GuiEventListener)this.searchBar);
            if (isActive) {
                this.setFocused((GuiEventListener)this.searchBar);
            }
            this.searchBar.setResponder(this::searchChange);
        } else {
            this.searchBar = null;
        }
        this.rebuild();
    }

    protected void rebuild() {
        if (this.panel != null) {
            this.removeWidget((GuiEventListener)this.panel);
        }
        ImmutableList.Builder widgetBuilder = ImmutableList.builder();
        this.buildGui(arg_0 -> ((ImmutableList.Builder)widgetBuilder).add(arg_0));
        ImmutableList widgets = widgetBuilder.build();
        final int totalHeight = 10 + widgets.stream().map(w -> w.getY() + w.getHeight()).max(Comparator.naturalOrder()).orElse(0);
        Objects.requireNonNull(this.mc.font);
        int paddingTop = 18 + 9 + (this.hasSearchBar ? 26 : 0);
        this.panel = new BasePanel(this.mc, this.width - 2, this.height - paddingTop, paddingTop, 1, (List)widgets){
            final /* synthetic */ List val$widgets;
            {
                this.val$widgets = list;
                super(mc, width, height, top, left);
            }

            protected int getContentHeight() {
                return totalHeight;
            }

            public void render(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                ConfigBaseScreen.this.isCapturingTooltips = true;
                graphics.pose().pushPose();
                super.render((GuiGraphics)new TooltipCapturingGuiGraphics(graphics), mouseX, mouseY, partialTicks);
                graphics.pose().popPose();
                ConfigBaseScreen.this.isCapturingTooltips = false;
                ConfigBaseScreen.this.capturedTooltips.forEach(pair -> {
                    graphics.pose().pushPose();
                    graphics.pose().setIdentity();
                    graphics.pose().mulPose((Matrix4f)pair.getLeft());
                    ((Consumer)pair.getRight()).accept(graphics);
                    graphics.pose().popPose();
                });
                ConfigBaseScreen.this.capturedTooltips.clear();
            }

            protected void drawPanel(@Nonnull GuiGraphics graphics, int entryRight, int relativeY, @Nonnull Tesselator tesselator, int mouseX, int mouseY) {
                ConfigBaseScreen.this.currentScrollOffset = relativeY;
                graphics.pose().pushPose();
                graphics.pose().translate(0.0f, (float)relativeY, 0.0f);
                for (AbstractWidget widget : this.val$widgets) {
                    widget.render(graphics, mouseX, mouseY - relativeY, ConfigBaseScreen.this.mc.getTimer().getGameTimeDeltaTicks());
                }
                graphics.pose().popPose();
                ConfigBaseScreen.this.currentScrollOffset = 0;
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (mouseX >= (double)this.left && mouseX <= (double)(this.left + this.width) && mouseY >= (double)this.top && mouseY <= (double)(this.top + this.height)) {
                    return super.mouseClicked(mouseX, mouseY, button);
                }
                return false;
            }

            protected boolean clickPanel(double mouseX, double mouseY, int button) {
                boolean success = false;
                for (GuiEventListener widget : this.val$widgets) {
                    if (!widget.mouseClicked(mouseX, mouseY, button)) continue;
                    this.setFocused(widget);
                    if (button == 0) {
                        this.setDragging(true);
                    }
                    success = true;
                }
                return success;
            }

            public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
                if (!super.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
                    if (this.getFocused() != null && this.isDragging() && button == 0) {
                        return this.getFocused().mouseDragged(mouseX, mouseY - (double)this.top + (double)((int)this.scrollDistance) - (double)this.border, button, dragX, dragY);
                    }
                    return false;
                }
                return true;
            }

            public boolean mouseReleased(double mouseX, double mouseY, int button) {
                if (!super.mouseReleased(mouseX, mouseY, button)) {
                    if (this.getFocused() != null) {
                        return this.getFocused().mouseReleased(mouseX, mouseY - (double)this.top + (double)((int)this.scrollDistance) - (double)this.border, button);
                    }
                    return false;
                }
                return true;
            }
        };
        this.addRenderableWidget((GuiEventListener)this.panel);
    }

    protected abstract void buildGui(Consumer<AbstractWidget> var1);

    @Nullable
    public ConfigScreenManager getCurrentManager() {
        return this.manager;
    }

    public void render(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderMenuBackground(graphics);
        super.render(graphics, mouseX, mouseY, partialTicks);
        RenderHelper.resetColor();
        graphics.drawString(this.font, this.getTitle(), (this.width - this.mc.font.width((FormattedText)this.getTitle())) / 2, 11, 0xFFFFFF, true);
    }

    public boolean keyPressed(int key, int i1, int i2) {
        if (key == 256 && this.shouldCloseOnEsc() && this.manager != null) {
            this.manager.close();
            return true;
        }
        return super.keyPressed(key, i1, i2);
    }

    public String searchTerm() {
        return this.searchBar == null ? "" : this.searchBar.getValue();
    }

    protected void searchChange(String term) {
    }

    private void captureTooltip(PoseStack.Pose pose, BiConsumer<GuiGraphics, Integer> action) {
        int theOffset = this.currentScrollOffset;
        Matrix4f matrix = new Matrix4f((Matrix4fc)pose.pose());
        matrix.translate(0.0f, (float)(-theOffset), 0.0f);
        this.capturedTooltips.add((Pair<Matrix4f, Consumer<GuiGraphics>>)Pair.of((Object)matrix, poseStack -> action.accept((GuiGraphics)poseStack, theOffset)));
    }

    private static abstract class BasePanel
    extends ScrollPanel
    implements NarratableEntry {
        public BasePanel(Minecraft mc, int width, int height, int top, int left) {
            super(mc, width, height, top, left);
        }

        @Nonnull
        public NarratableEntry.NarrationPriority narrationPriority() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void updateNarration(@Nonnull NarrationElementOutput output) {
        }
    }

    private class TooltipCapturingGuiGraphics
    extends FilterGuiGraphics {
        public TooltipCapturingGuiGraphics(GuiGraphics parent) {
            super(parent);
        }

        @Override
        public void renderTooltip(@Nonnull Font font, @Nonnull ItemStack stack, int x, int y) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.pose().last(), (graphics, scrollOffset) -> graphics.renderTooltip(font, stack, x, y + scrollOffset));
            } else {
                super.renderTooltip(font, stack, x, y);
            }
        }

        @Override
        public void renderTooltip(@Nonnull Font font, @Nonnull List<Component> text, @Nonnull Optional<TooltipComponent> component, @Nonnull ItemStack stack, int x, int y) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.pose().last(), (graphics, scrollOffset) -> graphics.renderTooltip(font, text, component, stack, x, y + scrollOffset));
            } else {
                super.renderTooltip(font, text, component, stack, x, y);
            }
        }

        @Override
        public void renderTooltip(@Nonnull Font font, @Nonnull List<Component> text, @Nonnull Optional<TooltipComponent> component, int x, int y) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.pose().last(), (graphics, scrollOffset) -> graphics.renderTooltip(font, text, component, x, y + scrollOffset));
            } else {
                super.renderTooltip(font, text, component, x, y);
            }
        }

        @Override
        public void renderTooltip(@Nonnull Font font, @Nonnull Component text, int x, int y) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.pose().last(), (graphics, scrollOffset) -> graphics.renderTooltip(font, text, x, y + scrollOffset));
            } else {
                super.renderTooltip(font, text, x, y);
            }
        }

        @Override
        public void renderComponentTooltip(@Nonnull Font font, @Nonnull List<Component> text, int x, int y) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.pose().last(), (graphics, scrollOffset) -> graphics.renderComponentTooltip(font, text, x, y + scrollOffset));
            } else {
                super.renderComponentTooltip(font, text, x, y);
            }
        }

        @Override
        public void renderComponentTooltip(@Nonnull Font font, @Nonnull List<? extends FormattedText> text, int x, int y, @Nonnull ItemStack stack) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.pose().last(), (graphics, scrollOffset) -> graphics.renderComponentTooltip(font, text, x, y + scrollOffset, stack));
            } else {
                super.renderComponentTooltip(font, text, x, y, stack);
            }
        }

        @Override
        public void renderTooltip(@Nonnull Font font, @Nonnull List<? extends FormattedCharSequence> text, int x, int y) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.pose().last(), (graphics, scrollOffset) -> graphics.renderTooltip(font, text, x, y + scrollOffset));
            } else {
                super.renderTooltip(font, text, x, y);
            }
        }

        @Override
        public void renderTooltip(@Nonnull Font font, @Nonnull List<FormattedCharSequence> text, @Nonnull ClientTooltipPositioner positioner, int x, int y) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.pose().last(), (graphics, scrollOffset) -> graphics.renderTooltip(font, text, positioner, x, y + scrollOffset));
            } else {
                super.renderTooltip(font, text, positioner, x, y);
            }
        }

        @Override
        public void renderComponentTooltipFromElements(@Nonnull Font font, @Nonnull List<Either<FormattedText, TooltipComponent>> elements, int mouseX, int mouseY, @Nonnull ItemStack stack) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.pose().last(), (graphics, scrollOffset) -> super.renderComponentTooltipFromElements(font, elements, mouseX, mouseY + scrollOffset, stack));
            } else {
                super.renderComponentTooltipFromElements(font, elements, mouseX, mouseY, stack);
            }
        }
    }
}

