/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.config.gui.editor;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.gui.WidgetProperties;

public class SliderEditor<T>
implements ConfigEditor<T> {
    private final Function<T, Double> extractor;
    private final Function<Double, T> factory;

    public SliderEditor(Function<T, Double> extractor, Function<Double, T> factory) {
        this.extractor = extractor;
        this.factory = factory;
    }

    @Override
    public T defaultValue() {
        return this.factory.apply(0.0);
    }

    @Override
    public AbstractWidget createWidget(Screen screen, T initialValue, WidgetProperties<T> properties) {
        return new SliderWidget<T>(this.factory, properties, initialValue, this.extractor.apply(initialValue));
    }

    @Override
    public AbstractWidget updateWidget(Screen screen, AbstractWidget old, WidgetProperties<T> properties) {
        if (old instanceof SliderWidget) {
            return new SliderWidget<T>(this.factory, properties, (SliderWidget)old);
        }
        return this.createWidget(screen, this.defaultValue(), properties);
    }

    private static class SliderWidget<T>
    extends AbstractSliderButton {
        private final Function<Double, T> factory;
        private final Consumer<T> inputChanged;
        private T current;

        public SliderWidget(Function<Double, T> factory, WidgetProperties<T> properties, SliderWidget<T> old) {
            this(factory, properties, old.current, old.value);
        }

        public SliderWidget(Function<Double, T> factory, WidgetProperties<T> properties, T current, double state) {
            super(properties.x(), properties.y(), properties.width(), properties.height(), (Component)Component.empty(), state);
            this.factory = factory;
            this.inputChanged = properties.inputChanged();
            this.current = current;
            this.value = Mth.clamp((double)state, (double)0.0, (double)1.0);
            this.updateMessage();
        }

        protected void updateMessage() {
            this.setMessage((Component)Component.literal((String)this.current.toString()));
        }

        protected void applyValue() {
            this.current = this.factory.apply(Mth.clamp((double)this.value, (double)0.0, (double)1.0));
            this.inputChanged.accept(this.current);
        }
    }
}

