/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.config;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.api.distmarker.OnlyIns;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.loading.FMLLoader;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.moddingx.libx.LibX;
import org.moddingx.libx.config.Config;
import org.moddingx.libx.config.Group;
import org.moddingx.libx.config.mapper.GenericValueMapper;
import org.moddingx.libx.config.mapper.MapperFactory;
import org.moddingx.libx.config.mapper.ValueMapper;
import org.moddingx.libx.config.validator.ConfigValidator;
import org.moddingx.libx.impl.config.gui.ModConfigGuiAdapter;
import org.moddingx.libx.impl.config.mappers.SimpleValueMappers;
import org.moddingx.libx.impl.config.mappers.advanced.ComponentValueMapper;
import org.moddingx.libx.impl.config.mappers.advanced.ResourceListValueMapper;
import org.moddingx.libx.impl.config.mappers.advanced.ResourceValueMapper;
import org.moddingx.libx.impl.config.mappers.advanced.UidValueMapper;
import org.moddingx.libx.impl.config.mappers.generic.ListValueMapper;
import org.moddingx.libx.impl.config.mappers.generic.MapValueMapper;
import org.moddingx.libx.impl.config.mappers.generic.OptionValueMapper;
import org.moddingx.libx.impl.config.mappers.generic.SetValueMapper;
import org.moddingx.libx.impl.config.mappers.special.EnumValueMapper;
import org.moddingx.libx.impl.config.mappers.special.PairValueMapper;
import org.moddingx.libx.impl.config.mappers.special.RecordValueMapper;
import org.moddingx.libx.impl.config.mappers.special.TripleValueMapper;
import org.moddingx.libx.impl.config.validators.SimpleValidators;
import org.moddingx.libx.impl.config.wrapper.JsonTypesafeMapper;
import org.moddingx.libx.impl.config.wrapper.TypesafeMapper;
import org.moddingx.libx.impl.config.wrapper.WrappedGenericMapper;
import org.moddingx.libx.util.ClassUtil;

public class ModMappers {
    private static final Map<String, ModMappers> modMappers = new HashMap<String, ModMappers>();
    private static final Map<Class<?>, ValueMapper<?, ?>> globalMappers = (Map)Stream.of(SimpleValueMappers.BOOLEAN, SimpleValueMappers.BYTE, SimpleValueMappers.SHORT, SimpleValueMappers.INTEGER, SimpleValueMappers.LONG, SimpleValueMappers.FLOAT, SimpleValueMappers.DOUBLE, SimpleValueMappers.STRING, ResourceValueMapper.INSTANCE, ComponentValueMapper.INSTANCE, ResourceListValueMapper.INSTANCE, UidValueMapper.INSTANCE).collect(ImmutableMap.toImmutableMap(ValueMapper::type, Function.identity()));
    private static final Map<Class<?>, GenericValueMapper<?, ?, ?>> globalGenericMappers = (Map)Stream.of(OptionValueMapper.INSTANCE, ListValueMapper.INSTANCE, SetValueMapper.INSTANCE, MapValueMapper.INSTANCE).collect(ImmutableMap.toImmutableMap(GenericValueMapper::type, Function.identity()));
    private static final Map<Class<? extends Annotation>, ConfigValidator<?, ?>> globalValidators = (Map)Stream.of(SimpleValidators.SHORT, SimpleValidators.INTEGER, SimpleValidators.LONG, SimpleValidators.FLOAT, SimpleValidators.DOUBLE).collect(ImmutableMap.toImmutableMap(ConfigValidator::annotation, Function.identity()));
    private final String modid;
    private final Map<Class<?>, MapperFactory<?>> mapperFactories = Collections.synchronizedMap(new HashMap());
    private final Map<Class<?>, ValueMapper<?, ?>> mappers = Collections.synchronizedMap(new HashMap());
    private final Map<Class<?>, GenericValueMapper<?, ?, ?>> genericMappers = Collections.synchronizedMap(new HashMap());
    private final Map<Class<? extends Annotation>, ConfigValidator<?, ?>> validators = Collections.synchronizedMap(new HashMap());
    private ModConfigGuiAdapter adapter = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModMappers get(String modid) {
        Map<String, ModMappers> map = modMappers;
        synchronized (map) {
            if (!modMappers.containsKey(modid)) {
                modMappers.put(modid, new ModMappers(modid));
            }
            return modMappers.get(modid);
        }
    }

    private ModMappers(String modid) {
        this.modid = modid;
    }

    public void registerValueMapper(ValueMapper<?, ?> mapper) {
        this.doRegisterValueMapper(this.mappers, mapper.type(), mapper);
    }

    public void registerValueMapperFactory(MapperFactory<?> factory) {
        this.doRegisterValueMapper(this.mapperFactories, factory.type(), factory);
    }

    public void registerValueMapper(GenericValueMapper<?, ?, ?> mapper) {
        this.doRegisterValueMapper(this.genericMappers, mapper.type(), mapper);
    }

    private <T> void doRegisterValueMapper(Map<Class<?>, T> map, Class<?> type, T mapper) {
        if (this.mapperFactories.containsKey(type) || this.mappers.containsKey(type) || this.genericMappers.containsKey(type)) {
            throw new IllegalStateException("Config mapper for type '" + String.valueOf(type) + "' is already registered.");
        }
        if (globalMappers.containsKey(type) || globalGenericMappers.containsKey(type)) {
            LibX.logger.warn(this.modid + " registers a custom value mapper for type " + String.valueOf(type) + ", shading a builtin one. This is discouraged.");
        }
        map.put(type, mapper);
    }

    public void registerConfigValidator(ConfigValidator<?, ?> validator) {
        if (this.validators.containsKey(validator.annotation())) {
            throw new IllegalStateException("Config validator for annotation '" + String.valueOf(validator.annotation()) + "' is already registered.");
        }
        if (globalValidators.containsKey(validator.annotation())) {
            throw new IllegalStateException("Config validator for annotation '" + String.valueOf(validator.annotation()) + "' is global, can't be changed. Add your own annotation.");
        }
        this.validators.put(validator.annotation(), validator);
    }

    public ValueMapper<?, ?> getMapper(Field field) {
        return this.getMapper(field.getGenericType());
    }

    private ValueMapper<?, ?> getMapper(Type type) {
        Class<?> cls = ClassUtil.boxed(ModMappers.getTypeClass(type));
        if (this.mapperFactories.containsKey(cls)) {
            ValueMapper<?, ?> mapper = this.mapperFactories.get(cls).create(ModMappers.getTypeContext(type));
            if (mapper == null) {
                throw new IllegalStateException("Mapper undefined in factory for type " + String.valueOf(type) + " (" + String.valueOf(cls) + ")");
            }
            return TypesafeMapper.of(mapper);
        }
        if (this.mappers.containsKey(cls)) {
            return this.mappers.get(cls);
        }
        if (this.genericMappers.containsKey(cls)) {
            return this.resolveGeneric(this.genericMappers.get(cls), type);
        }
        if (globalMappers.containsKey(cls)) {
            return globalMappers.get(cls);
        }
        if (globalGenericMappers.containsKey(cls)) {
            return this.resolveGeneric(globalGenericMappers.get(cls), type);
        }
        if (cls.isEnum()) {
            return EnumValueMapper.getMapper(cls);
        }
        if (cls == Pair.class) {
            return new PairValueMapper<Object, Object>(this.getWrappedMapperUnsafe(type, 0), this.getWrappedMapperUnsafe(type, 1));
        }
        if (cls == Triple.class) {
            return new TripleValueMapper<Object, Object, Object>(this.getWrappedMapperUnsafe(type, 0), this.getWrappedMapperUnsafe(type, 1), this.getWrappedMapperUnsafe(type, 2));
        }
        if (cls.isRecord()) {
            return new RecordValueMapper(this.modid, cls, this::getMapper);
        }
        throw new IllegalStateException("No config mapper found for type " + String.valueOf(type) + " (" + String.valueOf(cls) + ")");
    }

    private <T, E extends JsonElement> ValueMapper<T, E> resolveGeneric(GenericValueMapper<T, E, ?> mapper, Type type) {
        ValueMapper<Object, JsonElement> childMapper = this.getWrappedMapperUnsafe(type, mapper.getGenericElementPosition());
        return new WrappedGenericMapper<T, E, Object>(mapper, childMapper);
    }

    private ValueMapper<Object, JsonElement> getWrappedMapperUnsafe(Type type, int genericPosition) {
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalStateException("Generic value mapper used on type without generics.");
        }
        Type[] args = ((ParameterizedType)type).getActualTypeArguments();
        if (args.length <= genericPosition) {
            throw new IllegalStateException("Generic value mapper used on type with too less generics: Expected at least " + (genericPosition + 1) + ", got " + args.length);
        }
        ValueMapper<?, ?> mapper = this.getMapper(args[genericPosition]);
        return new JsonTypesafeMapper<Object>(mapper);
    }

    private static MapperFactory.Context getTypeContext(final Type type) {
        return new MapperFactory.Context(){

            @Override
            public Type getGenericType() {
                return type;
            }

            @Override
            public <T, C> ValueMapper<T, ?> wrap(GenericValueMapper<T, ?, C> mapper, ValueMapper<C, ?> child) {
                return new WrappedGenericMapper(mapper, new JsonTypesafeMapper<C>(child));
            }
        };
    }

    private static Class<?> getTypeClass(Type type) {
        Type type2 = type;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, ParameterizedType.class, TypeVariable.class, WildcardType.class}, (Object)type2, n)) {
            case 0 -> {
                Class<?> cls;
                yield cls = (Class<?>)type2;
            }
            case 1 -> {
                ParameterizedType ptype = (ParameterizedType)type2;
                yield ModMappers.getTypeClass(ptype.getRawType());
            }
            case 2 -> {
                TypeVariable typeVariable = (TypeVariable)type2;
                throw new IllegalStateException("Type variables are not allowed in config field types.");
            }
            case 3 -> {
                WildcardType wildcardType = (WildcardType)type2;
                throw new IllegalStateException("Wildcard types are not allowed in config field types.");
            }
            default -> throw new IllegalStateException("Unknown declared type of config field: " + String.valueOf(type));
        };
    }

    @Nullable
    public <A extends Annotation> ConfigValidator<?, A> getValidatorByAnnotation(Class<A> validatorClass) {
        if (Config.class.isAssignableFrom(validatorClass) || Group.class.isAssignableFrom(validatorClass) || OnlyIn.class.isAssignableFrom(validatorClass) || OnlyIns.class.isAssignableFrom(validatorClass)) {
            return null;
        }
        Optional<ConfigValidator> validator = globalValidators.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(validatorClass)).map(Map.Entry::getValue).findFirst();
        if (validator.isPresent()) {
            return validator.get();
        }
        validator = this.validators.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(validatorClass)).map(Map.Entry::getValue).findFirst();
        return validator.orElse(null);
    }

    public void initAdapter(ModContainer modContainer) {
        if (this.adapter == null && FMLLoader.getDist() == Dist.CLIENT) {
            this.adapter = new ModConfigGuiAdapter(this.modid, modContainer);
        }
    }

    public void configRegistered() {
        if (this.adapter != null) {
            this.adapter.checkRegister();
        }
    }
}

