/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.command.common;

import com.google.common.base.Suppliers;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class EntityDataCommand
implements Command<CommandSourceStack> {
    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        EntitySelector sel = (EntitySelector)context.getArgument("entities", EntitySelector.class);
        List entities = sel.findEntities((CommandSourceStack)context.getSource());
        CompoundTag nbt = (CompoundTag)context.getArgument("nbt", CompoundTag.class);
        boolean players = false;
        for (Entity entity : entities) {
            if (!(entity instanceof Player)) continue;
            if (!((CommandSourceStack)context.getSource()).hasPermission(4)) {
                throw new SimpleCommandExceptionType((Message)Component.translatable((String)"libx.command.entity_data.player_modify_no_permission")).create();
            }
            players = true;
        }
        for (Entity entity : entities) {
            UUID uid = entity.getUUID();
            CompoundTag entityNBT = entity.saveWithoutId(new CompoundTag());
            entityNBT.merge(nbt);
            entity.load(entityNBT);
            entity.setUUID(uid);
        }
        ((CommandSourceStack)context.getSource()).sendSuccess((Supplier)Suppliers.ofInstance((Object)Component.translatable((String)(players ? "libx.command.entity_data.modified_player" : "libx.command.entity_data.modified"), (Object[])new Object[]{entities.size()})), true);
        return 0;
    }
}

