/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.command.client;

import com.google.common.collect.Streams;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModInfo;
import org.moddingx.libx.util.game.ComponentUtil;

public class ModListCommand
implements Command<CommandSourceStack> {
    public final boolean detailed;

    public ModListCommand(boolean detailed) {
        this.detailed = detailed;
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Stream<MutableComponent> lineStream = ModList.get().getMods().stream().sorted(Comparator.comparing(IModInfo::getDisplayName)).filter(mod -> !mod.getModId().equalsIgnoreCase("minecraft")).map(mod -> mod.getDisplayName() + mod.getConfig().getConfigElement(new String[]{"authors"}).map(a -> " (by " + a.toString().trim() + ")").orElse("") + (String)(this.detailed && !mod.getDescription().trim().isEmpty() ? ": " + mod.getDescription().split("\n")[0].trim() : "")).map(Component::literal);
        List lines = Streams.mapWithIndex(lineStream, (line, idx) -> Objects.requireNonNull(line).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)(idx % 2L == 0L ? 0xFFFFFF : 0xA0A0A0))))).toList();
        String copyToClipboard = lines.stream().map(Component::getString).collect(Collectors.joining("\n"));
        lines.stream().map(line -> ComponentUtil.withCopyAction((Component)line, copyToClipboard)).forEach(line -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> line, false));
        return 0;
    }
}

