/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import net.minecraft.util.Unit;

public class FixedCodec<A>
implements Codec<Unit> {
    private final Dynamic<A> serializedValue;

    public FixedCodec(Dynamic<A> serializedValue) {
        this.serializedValue = serializedValue;
    }

    public <T> DataResult<T> encode(Unit unit, DynamicOps<T> ops, T prefix) {
        return ops.mergeToPrimitive(prefix, this.serializedValue.convert(ops).getValue());
    }

    public <T> DataResult<Pair<Unit, T>> decode(DynamicOps<T> ops, T input) {
        Dynamic dynamic = new Dynamic(ops, input).convert(this.serializedValue.getOps());
        if (Objects.equals(this.serializedValue, dynamic)) {
            return DataResult.success((Object)Pair.of((Object)Unit.INSTANCE, (Object)ops.empty()));
        }
        return DataResult.error(() -> "Wrong value in fixed streamCodec.");
    }

    public String toString() {
        return "FixedCodec[" + String.valueOf(this.serializedValue) + "]";
    }
}

