/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import net.neoforged.fml.common.asm.enumextension.IExtensibleEnum;
import org.moddingx.libx.codec.CodecHelper;

public class EnumCodec<A extends Enum<A>>
implements Codec<A> {
    private static final Map<Class<? extends Enum<?>>, EnumCodec<?>> INSTANCES = new HashMap();
    private final Class<A> clazz;
    private final boolean extensible;

    public static synchronized <A extends Enum<A>> EnumCodec<A> get(Class<A> clazz) {
        return INSTANCES.computeIfAbsent(clazz, c -> new EnumCodec(clazz));
    }

    private EnumCodec(Class<A> clazz) {
        if (!clazz.isEnum()) {
            throw new IllegalArgumentException("Can't create enum streamCodec for non-enum class: " + String.valueOf(clazz));
        }
        this.clazz = clazz;
        this.extensible = IExtensibleEnum.class.isAssignableFrom(this.clazz);
    }

    public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
        if (ops.compressMaps() && !this.extensible) {
            return ops.mergeToPrimitive(prefix, ops.createInt(((Enum)input).ordinal()));
        }
        return ops.mergeToPrimitive(prefix, ops.createString(((Enum)input).name()));
    }

    public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
        if (ops.compressMaps() && !this.extensible) {
            return CodecHelper.or(() -> this.decodeById(ops, input), () -> this.decodeByName(ops, input));
        }
        return CodecHelper.or(() -> this.decodeByName(ops, input), () -> this.decodeById(ops, input));
    }

    private <T> DataResult<Pair<A, T>> decodeById(DynamicOps<T> ops, T input) {
        return ops.getNumberValue(input).flatMap(number -> CodecHelper.doesNotThrow(() -> {
            Enum[] elems = (Enum[])this.clazz.getEnumConstants();
            try {
                return elems[number.intValue()];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalStateException("Invalid enum constant id: " + String.valueOf(number) + " (" + number.intValue() + ")");
            }
        })).map(r -> Pair.of((Object)r, (Object)ops.empty()));
    }

    private <T> DataResult<Pair<A, T>> decodeByName(DynamicOps<T> ops, T input) {
        return ops.getStringValue(input).flatMap(str -> CodecHelper.doesNotThrow(() -> Enum.valueOf(this.clazz, str))).map(r -> Pair.of((Object)r, (Object)ops.empty()));
    }

    public String toString() {
        return "EnumCodec[" + this.clazz.getName() + "]";
    }
}

